/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.DomainIspPlacement;
import com.amazonaws.services.simpleemailv2.model.VolumeStatistics;
import com.amazonaws.services.simpleemailv2.model.transform.OverallVolumeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OverallVolume
implements Serializable,
Cloneable,
StructuredPojo {
    private VolumeStatistics volumeStatistics;
    private Double readRatePercent;
    private List<DomainIspPlacement> domainIspPlacements;

    public void setVolumeStatistics(VolumeStatistics volumeStatistics) {
        this.volumeStatistics = volumeStatistics;
    }

    public VolumeStatistics getVolumeStatistics() {
        return this.volumeStatistics;
    }

    public OverallVolume withVolumeStatistics(VolumeStatistics volumeStatistics) {
        this.setVolumeStatistics(volumeStatistics);
        return this;
    }

    public void setReadRatePercent(Double readRatePercent) {
        this.readRatePercent = readRatePercent;
    }

    public Double getReadRatePercent() {
        return this.readRatePercent;
    }

    public OverallVolume withReadRatePercent(Double readRatePercent) {
        this.setReadRatePercent(readRatePercent);
        return this;
    }

    public List<DomainIspPlacement> getDomainIspPlacements() {
        return this.domainIspPlacements;
    }

    public void setDomainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements) {
        if (domainIspPlacements == null) {
            this.domainIspPlacements = null;
            return;
        }
        this.domainIspPlacements = new ArrayList<DomainIspPlacement>(domainIspPlacements);
    }

    public OverallVolume withDomainIspPlacements(DomainIspPlacement ... domainIspPlacements) {
        if (this.domainIspPlacements == null) {
            this.setDomainIspPlacements(new ArrayList<DomainIspPlacement>(domainIspPlacements.length));
        }
        for (DomainIspPlacement ele : domainIspPlacements) {
            this.domainIspPlacements.add(ele);
        }
        return this;
    }

    public OverallVolume withDomainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements) {
        this.setDomainIspPlacements(domainIspPlacements);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVolumeStatistics() != null) {
            sb.append("VolumeStatistics: ").append(this.getVolumeStatistics()).append(",");
        }
        if (this.getReadRatePercent() != null) {
            sb.append("ReadRatePercent: ").append(this.getReadRatePercent()).append(",");
        }
        if (this.getDomainIspPlacements() != null) {
            sb.append("DomainIspPlacements: ").append(this.getDomainIspPlacements());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverallVolume)) {
            return false;
        }
        OverallVolume other = (OverallVolume)obj;
        if (other.getVolumeStatistics() == null ^ this.getVolumeStatistics() == null) {
            return false;
        }
        if (other.getVolumeStatistics() != null && !other.getVolumeStatistics().equals(this.getVolumeStatistics())) {
            return false;
        }
        if (other.getReadRatePercent() == null ^ this.getReadRatePercent() == null) {
            return false;
        }
        if (other.getReadRatePercent() != null && !other.getReadRatePercent().equals(this.getReadRatePercent())) {
            return false;
        }
        if (other.getDomainIspPlacements() == null ^ this.getDomainIspPlacements() == null) {
            return false;
        }
        return other.getDomainIspPlacements() == null || other.getDomainIspPlacements().equals(this.getDomainIspPlacements());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumeStatistics() == null ? 0 : this.getVolumeStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getReadRatePercent() == null ? 0 : this.getReadRatePercent().hashCode());
        hashCode = 31 * hashCode + (this.getDomainIspPlacements() == null ? 0 : this.getDomainIspPlacements().hashCode());
        return hashCode;
    }

    public OverallVolume clone() {
        try {
            return (OverallVolume)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OverallVolumeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

