/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.servicecatalog;

import javax.annotation.Generated;

import com.amazonaws.services.servicecatalog.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSServiceCatalog}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSServiceCatalog implements AWSServiceCatalog {

    protected AbstractAWSServiceCatalog() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AcceptPortfolioShareResult acceptPortfolioShare(AcceptPortfolioShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociatePrincipalWithPortfolioResult associatePrincipalWithPortfolio(AssociatePrincipalWithPortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateProductWithPortfolioResult associateProductWithPortfolio(AssociateProductWithPortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateTagOptionWithResourceResult associateTagOptionWithResource(AssociateTagOptionWithResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CopyProductResult copyProduct(CopyProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConstraintResult createConstraint(CreateConstraintRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePortfolioResult createPortfolio(CreatePortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePortfolioShareResult createPortfolioShare(CreatePortfolioShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProductResult createProduct(CreateProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProvisioningArtifactResult createProvisioningArtifact(CreateProvisioningArtifactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTagOptionResult createTagOption(CreateTagOptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConstraintResult deleteConstraint(DeleteConstraintRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePortfolioResult deletePortfolio(DeletePortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePortfolioShareResult deletePortfolioShare(DeletePortfolioShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProductResult deleteProduct(DeleteProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProvisioningArtifactResult deleteProvisioningArtifact(DeleteProvisioningArtifactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConstraintResult describeConstraint(DescribeConstraintRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCopyProductStatusResult describeCopyProductStatus(DescribeCopyProductStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePortfolioResult describePortfolio(DescribePortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProductResult describeProduct(DescribeProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProductAsAdminResult describeProductAsAdmin(DescribeProductAsAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProductViewResult describeProductView(DescribeProductViewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProvisionedProductResult describeProvisionedProduct(DescribeProvisionedProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProvisioningArtifactResult describeProvisioningArtifact(DescribeProvisioningArtifactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProvisioningParametersResult describeProvisioningParameters(DescribeProvisioningParametersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRecordResult describeRecord(DescribeRecordRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTagOptionResult describeTagOption(DescribeTagOptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociatePrincipalFromPortfolioResult disassociatePrincipalFromPortfolio(DisassociatePrincipalFromPortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateProductFromPortfolioResult disassociateProductFromPortfolio(DisassociateProductFromPortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateTagOptionFromResourceResult disassociateTagOptionFromResource(DisassociateTagOptionFromResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAcceptedPortfolioSharesResult listAcceptedPortfolioShares(ListAcceptedPortfolioSharesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConstraintsForPortfolioResult listConstraintsForPortfolio(ListConstraintsForPortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLaunchPathsResult listLaunchPaths(ListLaunchPathsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPortfolioAccessResult listPortfolioAccess(ListPortfolioAccessRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPortfoliosResult listPortfolios(ListPortfoliosRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPortfoliosForProductResult listPortfoliosForProduct(ListPortfoliosForProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPrincipalsForPortfolioResult listPrincipalsForPortfolio(ListPrincipalsForPortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProvisioningArtifactsResult listProvisioningArtifacts(ListProvisioningArtifactsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRecordHistoryResult listRecordHistory(ListRecordHistoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourcesForTagOptionResult listResourcesForTagOption(ListResourcesForTagOptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagOptionsResult listTagOptions(ListTagOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ProvisionProductResult provisionProduct(ProvisionProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectPortfolioShareResult rejectPortfolioShare(RejectPortfolioShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ScanProvisionedProductsResult scanProvisionedProducts(ScanProvisionedProductsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchProductsResult searchProducts(SearchProductsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchProductsAsAdminResult searchProductsAsAdmin(SearchProductsAsAdminRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TerminateProvisionedProductResult terminateProvisionedProduct(TerminateProvisionedProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConstraintResult updateConstraint(UpdateConstraintRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePortfolioResult updatePortfolio(UpdatePortfolioRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProductResult updateProduct(UpdateProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProvisionedProductResult updateProvisionedProduct(UpdateProvisionedProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProvisioningArtifactResult updateProvisioningArtifact(UpdateProvisioningArtifactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTagOptionResult updateTagOption(UpdateTagOptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
