/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitylake.model.LakeConfigurationRequest;
import com.amazonaws.services.securitylake.model.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateDatalakeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Map<String, LakeConfigurationRequest> configurations;
    private Boolean enableAll;
    private String metaStoreManagerRoleArn;
    private List<String> regions;

    public Map<String, LakeConfigurationRequest> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, LakeConfigurationRequest> configurations) {
        this.configurations = configurations;
    }

    public CreateDatalakeRequest withConfigurations(Map<String, LakeConfigurationRequest> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public CreateDatalakeRequest addConfigurationsEntry(String key, LakeConfigurationRequest value) {
        if (null == this.configurations) {
            this.configurations = new HashMap<String, LakeConfigurationRequest>();
        }
        if (this.configurations.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.configurations.put(key, value);
        return this;
    }

    public CreateDatalakeRequest clearConfigurationsEntries() {
        this.configurations = null;
        return this;
    }

    public void setEnableAll(Boolean enableAll) {
        this.enableAll = enableAll;
    }

    public Boolean getEnableAll() {
        return this.enableAll;
    }

    public CreateDatalakeRequest withEnableAll(Boolean enableAll) {
        this.setEnableAll(enableAll);
        return this;
    }

    public Boolean isEnableAll() {
        return this.enableAll;
    }

    public void setMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
        this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
    }

    public String getMetaStoreManagerRoleArn() {
        return this.metaStoreManagerRoleArn;
    }

    public CreateDatalakeRequest withMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
        this.setMetaStoreManagerRoleArn(metaStoreManagerRoleArn);
        return this;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegions(Collection<String> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new ArrayList<String>(regions);
    }

    public CreateDatalakeRequest withRegions(String ... regions) {
        if (this.regions == null) {
            this.setRegions(new ArrayList<String>(regions.length));
        }
        for (String ele : regions) {
            this.regions.add(ele);
        }
        return this;
    }

    public CreateDatalakeRequest withRegions(Collection<String> regions) {
        this.setRegions(regions);
        return this;
    }

    public CreateDatalakeRequest withRegions(Region ... regions) {
        ArrayList<String> regionsCopy = new ArrayList<String>(regions.length);
        for (Region value : regions) {
            regionsCopy.add(value.toString());
        }
        if (this.getRegions() == null) {
            this.setRegions(regionsCopy);
        } else {
            this.getRegions().addAll(regionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations()).append(",");
        }
        if (this.getEnableAll() != null) {
            sb.append("EnableAll: ").append(this.getEnableAll()).append(",");
        }
        if (this.getMetaStoreManagerRoleArn() != null) {
            sb.append("MetaStoreManagerRoleArn: ").append(this.getMetaStoreManagerRoleArn()).append(",");
        }
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatalakeRequest)) {
            return false;
        }
        CreateDatalakeRequest other = (CreateDatalakeRequest)obj;
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        if (other.getConfigurations() != null && !other.getConfigurations().equals(this.getConfigurations())) {
            return false;
        }
        if (other.getEnableAll() == null ^ this.getEnableAll() == null) {
            return false;
        }
        if (other.getEnableAll() != null && !other.getEnableAll().equals(this.getEnableAll())) {
            return false;
        }
        if (other.getMetaStoreManagerRoleArn() == null ^ this.getMetaStoreManagerRoleArn() == null) {
            return false;
        }
        if (other.getMetaStoreManagerRoleArn() != null && !other.getMetaStoreManagerRoleArn().equals(this.getMetaStoreManagerRoleArn())) {
            return false;
        }
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        return other.getRegions() == null || other.getRegions().equals(this.getRegions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getEnableAll() == null ? 0 : this.getEnableAll().hashCode());
        hashCode = 31 * hashCode + (this.getMetaStoreManagerRoleArn() == null ? 0 : this.getMetaStoreManagerRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        return hashCode;
    }

    public CreateDatalakeRequest clone() {
        return (CreateDatalakeRequest)super.clone();
    }
}

