/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.securityhub.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AwsRedshiftClusterClusterSnapshotCopyStatusMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AwsRedshiftClusterClusterSnapshotCopyStatusMarshaller {

    private static final MarshallingInfo<String> DESTINATIONREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationRegion").build();
    private static final MarshallingInfo<Integer> MANUALSNAPSHOTRETENTIONPERIOD_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManualSnapshotRetentionPeriod").build();
    private static final MarshallingInfo<Integer> RETENTIONPERIOD_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetentionPeriod").build();
    private static final MarshallingInfo<String> SNAPSHOTCOPYGRANTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotCopyGrantName").build();

    private static final AwsRedshiftClusterClusterSnapshotCopyStatusMarshaller instance = new AwsRedshiftClusterClusterSnapshotCopyStatusMarshaller();

    public static AwsRedshiftClusterClusterSnapshotCopyStatusMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AwsRedshiftClusterClusterSnapshotCopyStatus awsRedshiftClusterClusterSnapshotCopyStatus, ProtocolMarshaller protocolMarshaller) {

        if (awsRedshiftClusterClusterSnapshotCopyStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(awsRedshiftClusterClusterSnapshotCopyStatus.getDestinationRegion(), DESTINATIONREGION_BINDING);
            protocolMarshaller.marshall(awsRedshiftClusterClusterSnapshotCopyStatus.getManualSnapshotRetentionPeriod(), MANUALSNAPSHOTRETENTIONPERIOD_BINDING);
            protocolMarshaller.marshall(awsRedshiftClusterClusterSnapshotCopyStatus.getRetentionPeriod(), RETENTIONPERIOD_BINDING);
            protocolMarshaller.marshall(awsRedshiftClusterClusterSnapshotCopyStatus.getSnapshotCopyGrantName(), SNAPSHOTCOPYGRANTNAME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
