/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides information about the logging status of the cluster.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsRedshiftClusterLoggingStatus"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsRedshiftClusterLoggingStatus implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the S3 bucket where the log files are stored.
     * </p>
     */
    private String bucketName;
    /**
     * <p>
     * The message indicating that the logs failed to be delivered.
     * </p>
     */
    private String lastFailureMessage;
    /**
     * <p>
     * The last time when logs failed to be delivered.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     */
    private String lastFailureTime;
    /**
     * <p>
     * The last time that logs were delivered successfully.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     */
    private String lastSuccessfulDeliveryTime;
    /**
     * <p>
     * Indicates whether logging is enabled.
     * </p>
     */
    private Boolean loggingEnabled;
    /**
     * <p>
     * Provides the prefix applied to the log file names.
     * </p>
     */
    private String s3KeyPrefix;

    /**
     * <p>
     * The name of the S3 bucket where the log files are stored.
     * </p>
     * 
     * @param bucketName
     *        The name of the S3 bucket where the log files are stored.
     */

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    /**
     * <p>
     * The name of the S3 bucket where the log files are stored.
     * </p>
     * 
     * @return The name of the S3 bucket where the log files are stored.
     */

    public String getBucketName() {
        return this.bucketName;
    }

    /**
     * <p>
     * The name of the S3 bucket where the log files are stored.
     * </p>
     * 
     * @param bucketName
     *        The name of the S3 bucket where the log files are stored.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsRedshiftClusterLoggingStatus withBucketName(String bucketName) {
        setBucketName(bucketName);
        return this;
    }

    /**
     * <p>
     * The message indicating that the logs failed to be delivered.
     * </p>
     * 
     * @param lastFailureMessage
     *        The message indicating that the logs failed to be delivered.
     */

    public void setLastFailureMessage(String lastFailureMessage) {
        this.lastFailureMessage = lastFailureMessage;
    }

    /**
     * <p>
     * The message indicating that the logs failed to be delivered.
     * </p>
     * 
     * @return The message indicating that the logs failed to be delivered.
     */

    public String getLastFailureMessage() {
        return this.lastFailureMessage;
    }

    /**
     * <p>
     * The message indicating that the logs failed to be delivered.
     * </p>
     * 
     * @param lastFailureMessage
     *        The message indicating that the logs failed to be delivered.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsRedshiftClusterLoggingStatus withLastFailureMessage(String lastFailureMessage) {
        setLastFailureMessage(lastFailureMessage);
        return this;
    }

    /**
     * <p>
     * The last time when logs failed to be delivered.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param lastFailureTime
     *        The last time when logs failed to be delivered.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public void setLastFailureTime(String lastFailureTime) {
        this.lastFailureTime = lastFailureTime;
    }

    /**
     * <p>
     * The last time when logs failed to be delivered.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The last time when logs failed to be delivered.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public String getLastFailureTime() {
        return this.lastFailureTime;
    }

    /**
     * <p>
     * The last time when logs failed to be delivered.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param lastFailureTime
     *        The last time when logs failed to be delivered.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsRedshiftClusterLoggingStatus withLastFailureTime(String lastFailureTime) {
        setLastFailureTime(lastFailureTime);
        return this;
    }

    /**
     * <p>
     * The last time that logs were delivered successfully.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param lastSuccessfulDeliveryTime
     *        The last time that logs were delivered successfully.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public void setLastSuccessfulDeliveryTime(String lastSuccessfulDeliveryTime) {
        this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
    }

    /**
     * <p>
     * The last time that logs were delivered successfully.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The last time that logs were delivered successfully.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */

    public String getLastSuccessfulDeliveryTime() {
        return this.lastSuccessfulDeliveryTime;
    }

    /**
     * <p>
     * The last time that logs were delivered successfully.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @param lastSuccessfulDeliveryTime
     *        The last time that logs were delivered successfully.</p>
     *        <p>
     *        Uses the <code>date-time</code> format specified in <a
     *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *        example, <code>2020-03-22T13:22:13.933Z</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsRedshiftClusterLoggingStatus withLastSuccessfulDeliveryTime(String lastSuccessfulDeliveryTime) {
        setLastSuccessfulDeliveryTime(lastSuccessfulDeliveryTime);
        return this;
    }

    /**
     * <p>
     * Indicates whether logging is enabled.
     * </p>
     * 
     * @param loggingEnabled
     *        Indicates whether logging is enabled.
     */

    public void setLoggingEnabled(Boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    /**
     * <p>
     * Indicates whether logging is enabled.
     * </p>
     * 
     * @return Indicates whether logging is enabled.
     */

    public Boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    /**
     * <p>
     * Indicates whether logging is enabled.
     * </p>
     * 
     * @param loggingEnabled
     *        Indicates whether logging is enabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsRedshiftClusterLoggingStatus withLoggingEnabled(Boolean loggingEnabled) {
        setLoggingEnabled(loggingEnabled);
        return this;
    }

    /**
     * <p>
     * Indicates whether logging is enabled.
     * </p>
     * 
     * @return Indicates whether logging is enabled.
     */

    public Boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    /**
     * <p>
     * Provides the prefix applied to the log file names.
     * </p>
     * 
     * @param s3KeyPrefix
     *        Provides the prefix applied to the log file names.
     */

    public void setS3KeyPrefix(String s3KeyPrefix) {
        this.s3KeyPrefix = s3KeyPrefix;
    }

    /**
     * <p>
     * Provides the prefix applied to the log file names.
     * </p>
     * 
     * @return Provides the prefix applied to the log file names.
     */

    public String getS3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    /**
     * <p>
     * Provides the prefix applied to the log file names.
     * </p>
     * 
     * @param s3KeyPrefix
     *        Provides the prefix applied to the log file names.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsRedshiftClusterLoggingStatus withS3KeyPrefix(String s3KeyPrefix) {
        setS3KeyPrefix(s3KeyPrefix);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBucketName() != null)
            sb.append("BucketName: ").append(getBucketName()).append(",");
        if (getLastFailureMessage() != null)
            sb.append("LastFailureMessage: ").append(getLastFailureMessage()).append(",");
        if (getLastFailureTime() != null)
            sb.append("LastFailureTime: ").append(getLastFailureTime()).append(",");
        if (getLastSuccessfulDeliveryTime() != null)
            sb.append("LastSuccessfulDeliveryTime: ").append(getLastSuccessfulDeliveryTime()).append(",");
        if (getLoggingEnabled() != null)
            sb.append("LoggingEnabled: ").append(getLoggingEnabled()).append(",");
        if (getS3KeyPrefix() != null)
            sb.append("S3KeyPrefix: ").append(getS3KeyPrefix());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsRedshiftClusterLoggingStatus == false)
            return false;
        AwsRedshiftClusterLoggingStatus other = (AwsRedshiftClusterLoggingStatus) obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null)
            return false;
        if (other.getBucketName() != null && other.getBucketName().equals(this.getBucketName()) == false)
            return false;
        if (other.getLastFailureMessage() == null ^ this.getLastFailureMessage() == null)
            return false;
        if (other.getLastFailureMessage() != null && other.getLastFailureMessage().equals(this.getLastFailureMessage()) == false)
            return false;
        if (other.getLastFailureTime() == null ^ this.getLastFailureTime() == null)
            return false;
        if (other.getLastFailureTime() != null && other.getLastFailureTime().equals(this.getLastFailureTime()) == false)
            return false;
        if (other.getLastSuccessfulDeliveryTime() == null ^ this.getLastSuccessfulDeliveryTime() == null)
            return false;
        if (other.getLastSuccessfulDeliveryTime() != null && other.getLastSuccessfulDeliveryTime().equals(this.getLastSuccessfulDeliveryTime()) == false)
            return false;
        if (other.getLoggingEnabled() == null ^ this.getLoggingEnabled() == null)
            return false;
        if (other.getLoggingEnabled() != null && other.getLoggingEnabled().equals(this.getLoggingEnabled()) == false)
            return false;
        if (other.getS3KeyPrefix() == null ^ this.getS3KeyPrefix() == null)
            return false;
        if (other.getS3KeyPrefix() != null && other.getS3KeyPrefix().equals(this.getS3KeyPrefix()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBucketName() == null) ? 0 : getBucketName().hashCode());
        hashCode = prime * hashCode + ((getLastFailureMessage() == null) ? 0 : getLastFailureMessage().hashCode());
        hashCode = prime * hashCode + ((getLastFailureTime() == null) ? 0 : getLastFailureTime().hashCode());
        hashCode = prime * hashCode + ((getLastSuccessfulDeliveryTime() == null) ? 0 : getLastSuccessfulDeliveryTime().hashCode());
        hashCode = prime * hashCode + ((getLoggingEnabled() == null) ? 0 : getLoggingEnabled().hashCode());
        hashCode = prime * hashCode + ((getS3KeyPrefix() == null) ? 0 : getS3KeyPrefix().hashCode());
        return hashCode;
    }

    @Override
    public AwsRedshiftClusterLoggingStatus clone() {
        try {
            return (AwsRedshiftClusterLoggingStatus) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsRedshiftClusterLoggingStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
