/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securityhub.model.GeoLocation;

@SdkInternalApi
public class GeoLocationMarshaller {
    private static final MarshallingInfo<Double> LON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lon").build();
    private static final MarshallingInfo<Double> LAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lat").build();
    private static final GeoLocationMarshaller instance = new GeoLocationMarshaller();

    public static GeoLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(GeoLocation geoLocation, ProtocolMarshaller protocolMarshaller) {
        if (geoLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)geoLocation.getLon(), LON_BINDING);
            protocolMarshaller.marshall((Object)geoLocation.getLat(), LAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

