/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.MetricDatum;

@SdkInternalApi
public class MetricDatumMarshaller {
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").build();
    private static final MarshallingInfo<Float> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<String> SET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Set").build();
    private static final MarshallingInfo<String> STANDARDMETRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardMetricName").build();
    private static final MetricDatumMarshaller instance = new MetricDatumMarshaller();

    public static MetricDatumMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricDatum metricDatum, ProtocolMarshaller protocolMarshaller) {
        if (metricDatum == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricDatum.getMetricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)metricDatum.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)metricDatum.getSet(), SET_BINDING);
            protocolMarshaller.marshall((Object)metricDatum.getStandardMetricName(), STANDARDMETRICNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

