/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.S3Retention;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class S3RetentionStaxUnmarshaller
implements Unmarshaller<S3Retention, StaxUnmarshallerContext> {
    private static S3RetentionStaxUnmarshaller instance;

    public S3Retention unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3Retention s3Retention = new S3Retention();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3Retention;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("RetainUntilDate", targetDepth)) {
                    s3Retention.setRetainUntilDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Mode", targetDepth)) continue;
                s3Retention.setMode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3Retention;
    }

    public static S3RetentionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3RetentionStaxUnmarshaller();
        }
        return instance;
    }
}

