/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.PublicAccessBlockConfiguration;
import com.amazonaws.services.s3control.model.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateMultiRegionAccessPointInput
implements Serializable,
Cloneable {
    private String name;
    private PublicAccessBlockConfiguration publicAccessBlock;
    private List<Region> regions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateMultiRegionAccessPointInput withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPublicAccessBlock(PublicAccessBlockConfiguration publicAccessBlock) {
        this.publicAccessBlock = publicAccessBlock;
    }

    public PublicAccessBlockConfiguration getPublicAccessBlock() {
        return this.publicAccessBlock;
    }

    public CreateMultiRegionAccessPointInput withPublicAccessBlock(PublicAccessBlockConfiguration publicAccessBlock) {
        this.setPublicAccessBlock(publicAccessBlock);
        return this;
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public void setRegions(Collection<Region> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new ArrayList<Region>(regions);
    }

    public CreateMultiRegionAccessPointInput withRegions(Region ... regions) {
        if (this.regions == null) {
            this.setRegions(new ArrayList<Region>(regions.length));
        }
        for (Region ele : regions) {
            this.regions.add(ele);
        }
        return this;
    }

    public CreateMultiRegionAccessPointInput withRegions(Collection<Region> regions) {
        this.setRegions(regions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPublicAccessBlock() != null) {
            sb.append("PublicAccessBlock: ").append(this.getPublicAccessBlock()).append(",");
        }
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionAccessPointInput)) {
            return false;
        }
        CreateMultiRegionAccessPointInput other = (CreateMultiRegionAccessPointInput)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPublicAccessBlock() == null ^ this.getPublicAccessBlock() == null) {
            return false;
        }
        if (other.getPublicAccessBlock() != null && !other.getPublicAccessBlock().equals(this.getPublicAccessBlock())) {
            return false;
        }
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        return other.getRegions() == null || other.getRegions().equals(this.getRegions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPublicAccessBlock() == null ? 0 : this.getPublicAccessBlock().hashCode());
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        return hashCode;
    }

    public CreateMultiRegionAccessPointInput clone() {
        try {
            return (CreateMultiRegionAccessPointInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

