/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.internal.handlers;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.arn.Arn;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.internal.S3OutpostResource;
import com.amazonaws.services.s3.internal.UseArnRegionResolver;
import com.amazonaws.services.s3control.S3ArnableField;
import com.amazonaws.services.s3control.S3ControlClientOptions;
import com.amazonaws.services.s3control.S3ControlHandlerContextKey;
import com.amazonaws.services.s3control.internal.HandlerUtils;
import com.amazonaws.services.s3control.internal.S3ControlArnConverter;
import com.amazonaws.services.s3control.model.CreateBucketRequest;
import com.amazonaws.services.s3control.model.ListRegionalBucketsRequest;
import com.amazonaws.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;

@SdkInternalApi
public final class EndpointHandler
extends RequestHandler2 {
    private static final UseArnRegionResolver USE_ARN_REGION_RESOLVER = new UseArnRegionResolver();
    private static final String X_AMZ_OUTPOST_ID_HEADER = "x-amz-outpost-id";

    public void beforeRequest(Request<?> request) {
        Arn requestArn = this.getRequestArn(request);
        if (requestArn != null) {
            this.resolveHostForOutpostArnRequest(request, requestArn);
        } else if (this.isNonArnOutpostRequest(request)) {
            this.resolveHostForOutpostNonArnRequest(request);
        } else {
            this.resolveHostForNonOutpostNonArnRequest(request);
        }
    }

    private void resolveHostForOutpostArnRequest(Request<?> request, Arn arn) {
        S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
        String signingRegion = (String)request.getHandlerContext(HandlerContextKey.SIGNING_REGION);
        String arnRegion = this.arnRegion(arn);
        String arnPartition = arn.getPartition();
        S3Resource parentS3Resource = s3Resource.getParentS3Resource();
        this.validateIsTrue(!this.willCallFipsRegion(signingRegion, arnRegion, request), "FIPS is not supported for outpost requests.", new Object[0]);
        signingRegion = this.removeFipsIfNeeded(signingRegion);
        String signingPartition = RegionUtils.getRegion((String)signingRegion).getPartition();
        S3OutpostResource outpostResource = this.validateIsInstanceOf(S3OutpostResource.class, parentS3Resource, "The ARN passed must have a parent outpost resource.", new Object[0]);
        this.validateIsTrue(!HandlerUtils.isDualstackEnabled(request), "Dual stack endpoints are not supported for outpost requests.", new Object[0]);
        this.validateIsTrue(arnPartition.equals(signingPartition), "The partition field of the ARN being passed as a bucket parameter to an S3 operation does not match the partition the client has been configured with. Provided partition: '%s'; client partition: '%s'.", arnPartition, signingPartition);
        this.validateIsTrue(this.useArnRegion(request) || arnRegion.equals(signingRegion), "The region field of the ARN being passed as a bucket parameter to an operation does not match the region the client was configured with. Provided region: '%s'; client region: '%s'.", arnRegion, signingRegion);
        request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)arnRegion);
        request.addHandlerContext(HandlerContextKey.SIGNING_NAME, (Object)"s3-outposts");
        request.addHeader(X_AMZ_OUTPOST_ID_HEADER, outpostResource.getOutpostId());
        if (this.isEndpointOverridden(request)) {
            this.replaceHost(request, this.clientEndpoint(request).getHost());
        } else {
            String arnPartitionDnsSuffix = RegionUtils.getRegion((String)arnRegion).getDomain();
            request.setEndpoint(URI.create(String.format("%s://s3-outposts.%s.%s", request.getEndpoint().getScheme(), arnRegion, arnPartitionDnsSuffix)));
        }
    }

    private void resolveHostForOutpostNonArnRequest(Request<?> request) {
        String signingRegion = (String)request.getHandlerContext(HandlerContextKey.SIGNING_REGION);
        this.validateIsTrue(!HandlerUtils.isDualstackEnabled(request), "Dual stack is not supported for outpost requests.", new Object[0]);
        this.validateIsTrue(!HandlerUtils.isFipsEnabledInClientConfig(request) && !HandlerUtils.isFipsRegion(signingRegion), "FIPS endpoints are not supported for outpost requests.", new Object[0]);
        request.addHandlerContext(HandlerContextKey.SIGNING_NAME, (Object)"s3-outposts");
        if (!this.isEndpointOverridden(request)) {
            String signingDnsSuffix = RegionUtils.getRegion((String)signingRegion).getDomain();
            this.replaceHost(request, String.format("s3-outposts.%s.%s", signingRegion, signingDnsSuffix));
        }
    }

    private void resolveHostForNonOutpostNonArnRequest(Request<?> request) {
        boolean isDualStackEnabled = HandlerUtils.isDualstackEnabled(request);
        boolean isFipsEnabledInClient = HandlerUtils.isFipsEnabledInClientConfig(request);
        this.validateIsTrue(!isDualStackEnabled || !isFipsEnabledInClient, "Dual stack and FIPS are not supported together.", new Object[0]);
        if (this.isEndpointOverridden(request)) {
            this.validateIsTrue(!isDualStackEnabled, "Dual stack is not supported with endpoint overrides.", new Object[0]);
            this.validateIsTrue(!isFipsEnabledInClient, "FIPS is not supported with endpoint overrides.", new Object[0]);
        } else if (isDualStackEnabled) {
            String newEndpointPrefix = String.format("%s.%s", "s3-control", "dualstack");
            this.replaceHost(request, request.getEndpoint().getHost().replace("s3-control", newEndpointPrefix));
        } else if (isFipsEnabledInClient) {
            String newEndpointPrefix = String.format("%s-%s", "s3-control", "fips");
            this.replaceHost(request, request.getEndpoint().getHost().replace("s3-control", newEndpointPrefix));
        }
    }

    private Arn getRequestArn(Request<?> request) {
        S3ArnableField field = (S3ArnableField)request.getHandlerContext(S3ControlHandlerContextKey.S3_ARNABLE_FIELD);
        return field != null ? field.getArn() : null;
    }

    private boolean isEndpointOverridden(Request<?> request) {
        return Boolean.TRUE.equals(request.getHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN));
    }

    private void replaceHost(Request<?> request, String newHost) {
        URI currentEndpoint = request.getEndpoint();
        try {
            request.setEndpoint(new URI(currentEndpoint.getScheme(), currentEndpoint.getUserInfo(), newHost, currentEndpoint.getPort(), currentEndpoint.getPath(), currentEndpoint.getQuery(), currentEndpoint.getFragment()));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isNonArnOutpostRequest(Request<?> request) {
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest instanceof CreateBucketRequest && !StringUtils.isNullOrEmpty((String)((CreateBucketRequest)originalRequest).getOutpostId())) {
            return true;
        }
        return originalRequest instanceof ListRegionalBucketsRequest && !StringUtils.isNullOrEmpty((String)((ListRegionalBucketsRequest)originalRequest).getOutpostId());
    }

    private URI clientEndpoint(Request<?> request) {
        return (URI)request.getHandlerContext(HandlerContextKey.CLIENT_ENDPOINT);
    }

    private String arnRegion(Arn arn) {
        String region = arn.getRegion();
        if (region == null) {
            throw new IllegalArgumentException("Region is missing from ARN: " + arn);
        }
        return region;
    }

    private boolean useArnRegion(Request<?> request) {
        if (HandlerUtils.isAdvancedConfigFlagTrue(request, S3ControlClientOptions.USE_ARN_REGION_ENABLED)) {
            return true;
        }
        return USE_ARN_REGION_RESOLVER.useArnRegion();
    }

    private boolean willCallFipsRegion(String signingRegion, String arnRegion, Request<?> request) {
        if (this.useArnRegion(request)) {
            return HandlerUtils.isFipsRegion(arnRegion);
        }
        if (HandlerUtils.isFipsEnabledInClientConfig(request)) {
            return true;
        }
        return HandlerUtils.isFipsRegion(signingRegion);
    }

    private String removeFipsIfNeeded(String region) {
        if (region.startsWith("fips-")) {
            return region.replace("fips-", "");
        }
        if (region.endsWith("-fips")) {
            return region.replace("-fips", "");
        }
        return region;
    }

    private void validateIsTrue(boolean condition, String error, Object ... params) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(error, params));
        }
    }

    private <T> T validateIsInstanceOf(Class<T> clazz, Object toValidate, String error, Object ... params) {
        if (!clazz.isAssignableFrom(toValidate.getClass())) {
            throw new IllegalArgumentException(String.format(error, params));
        }
        return clazz.cast(toValidate);
    }
}

