/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListCidrLocationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class ListCidrLocationsRequestMarshaller
implements Marshaller<Request<ListCidrLocationsRequest>, ListCidrLocationsRequest> {
    public Request<ListCidrLocationsRequest> marshall(ListCidrLocationsRequest listCidrLocationsRequest) {
        if (listCidrLocationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCidrLocationsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/cidrcollection/{CidrCollectionId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "CidrCollectionId", listCidrLocationsRequest.getCollectionId());
        request.setResourcePath(uriResourcePath);
        if (listCidrLocationsRequest.getNextToken() != null) {
            request.addParameter("nexttoken", StringUtils.fromString((String)listCidrLocationsRequest.getNextToken()));
        }
        if (listCidrLocationsRequest.getMaxResults() != null) {
            request.addParameter("maxresults", StringUtils.fromString((String)listCidrLocationsRequest.getMaxResults()));
        }
        return request;
    }
}

