/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.Tag;
import com.amazonaws.services.route53.model.TagResourceType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ChangeTagsForResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceType;
    private String resourceId;
    private SdkInternalList<Tag> addTags;
    private SdkInternalList<String> removeTagKeys;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @JsonProperty(value="resourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    public ChangeTagsForResourceRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    @JsonIgnore
    public void setResourceType(TagResourceType resourceType) {
        this.withResourceType(resourceType);
    }

    public ChangeTagsForResourceRequest withResourceType(TagResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ChangeTagsForResourceRequest withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public List<Tag> getAddTags() {
        if (this.addTags == null) {
            this.addTags = new SdkInternalList();
        }
        return this.addTags;
    }

    public void setAddTags(Collection<Tag> addTags) {
        if (addTags == null) {
            this.addTags = null;
            return;
        }
        this.addTags = new SdkInternalList(addTags);
    }

    public ChangeTagsForResourceRequest withAddTags(Tag ... addTags) {
        if (this.addTags == null) {
            this.setAddTags((Collection<Tag>)new SdkInternalList(addTags.length));
        }
        for (Tag ele : addTags) {
            this.addTags.add((Object)ele);
        }
        return this;
    }

    public ChangeTagsForResourceRequest withAddTags(Collection<Tag> addTags) {
        this.setAddTags(addTags);
        return this;
    }

    public List<String> getRemoveTagKeys() {
        if (this.removeTagKeys == null) {
            this.removeTagKeys = new SdkInternalList();
        }
        return this.removeTagKeys;
    }

    public void setRemoveTagKeys(Collection<String> removeTagKeys) {
        if (removeTagKeys == null) {
            this.removeTagKeys = null;
            return;
        }
        this.removeTagKeys = new SdkInternalList(removeTagKeys);
    }

    public ChangeTagsForResourceRequest withRemoveTagKeys(String ... removeTagKeys) {
        if (this.removeTagKeys == null) {
            this.setRemoveTagKeys((Collection<String>)new SdkInternalList(removeTagKeys.length));
        }
        for (String ele : removeTagKeys) {
            this.removeTagKeys.add((Object)ele);
        }
        return this;
    }

    public ChangeTagsForResourceRequest withRemoveTagKeys(Collection<String> removeTagKeys) {
        this.setRemoveTagKeys(removeTagKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getAddTags() != null) {
            sb.append("AddTags: ").append(this.getAddTags()).append(",");
        }
        if (this.getRemoveTagKeys() != null) {
            sb.append("RemoveTagKeys: ").append(this.getRemoveTagKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeTagsForResourceRequest)) {
            return false;
        }
        ChangeTagsForResourceRequest other = (ChangeTagsForResourceRequest)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getAddTags() == null ^ this.getAddTags() == null) {
            return false;
        }
        if (other.getAddTags() != null && !other.getAddTags().equals(this.getAddTags())) {
            return false;
        }
        if (other.getRemoveTagKeys() == null ^ this.getRemoveTagKeys() == null) {
            return false;
        }
        return other.getRemoveTagKeys() == null || other.getRemoveTagKeys().equals(this.getRemoveTagKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getAddTags() == null ? 0 : this.getAddTags().hashCode());
        hashCode = 31 * hashCode + (this.getRemoveTagKeys() == null ? 0 : this.getRemoveTagKeys().hashCode());
        return hashCode;
    }

    public ChangeTagsForResourceRequest clone() {
        return (ChangeTagsForResourceRequest)super.clone();
    }
}

