/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.TagResourceType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListTagsForResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceType;
    private SdkInternalList<String> resourceIds;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ListTagsForResourcesRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    @JsonIgnore
    public void setResourceType(TagResourceType resourceType) {
        this.resourceType = resourceType.toString();
    }

    public ListTagsForResourcesRequest withResourceType(TagResourceType resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public List<String> getResourceIds() {
        if (this.resourceIds == null) {
            this.resourceIds = new SdkInternalList();
        }
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        this.resourceIds = new SdkInternalList(resourceIds);
    }

    public ListTagsForResourcesRequest withResourceIds(String ... resourceIds) {
        if (this.resourceIds == null) {
            this.setResourceIds((Collection<String>)new SdkInternalList(resourceIds.length));
        }
        for (String ele : resourceIds) {
            this.resourceIds.add((Object)ele);
        }
        return this;
    }

    public ListTagsForResourcesRequest withResourceIds(Collection<String> resourceIds) {
        this.setResourceIds(resourceIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: ").append(this.getResourceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesRequest)) {
            return false;
        }
        ListTagsForResourcesRequest other = (ListTagsForResourcesRequest)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        return other.getResourceIds() == null || other.getResourceIds().equals(this.getResourceIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        return hashCode;
    }

    public ListTagsForResourcesRequest clone() {
        return (ListTagsForResourcesRequest)super.clone();
    }
}

