/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.Compute;

@SdkInternalApi
public class ComputeMarshaller {
    private static final MarshallingInfo<Integer> SIMULATIONUNITLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("simulationUnitLimit").build();
    private static final MarshallingInfo<String> COMPUTETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computeType").build();
    private static final MarshallingInfo<Integer> GPUUNITLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gpuUnitLimit").build();
    private static final ComputeMarshaller instance = new ComputeMarshaller();

    public static ComputeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Compute compute, ProtocolMarshaller protocolMarshaller) {
        if (compute == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)compute.getSimulationUnitLimit(), SIMULATIONUNITLIMIT_BINDING);
            protocolMarshaller.marshall((Object)compute.getComputeType(), COMPUTETYPE_BINDING);
            protocolMarshaller.marshall((Object)compute.getGpuUnitLimit(), GPUUNITLIMIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

