/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.DataLocationConstraint;
import com.amazonaws.services.resiliencehub.model.EstimatedCostTier;
import com.amazonaws.services.resiliencehub.model.FailurePolicy;
import com.amazonaws.services.resiliencehub.model.ResiliencyPolicyTier;
import com.amazonaws.services.resiliencehub.model.transform.ResiliencyPolicyMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ResiliencyPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private Date creationTime;
    private String dataLocationConstraint;
    private String estimatedCostTier;
    private Map<String, FailurePolicy> policy;
    private String policyArn;
    private String policyDescription;
    private String policyName;
    private Map<String, String> tags;
    private String tier;

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public ResiliencyPolicy withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setDataLocationConstraint(String dataLocationConstraint) {
        this.dataLocationConstraint = dataLocationConstraint;
    }

    public String getDataLocationConstraint() {
        return this.dataLocationConstraint;
    }

    public ResiliencyPolicy withDataLocationConstraint(String dataLocationConstraint) {
        this.setDataLocationConstraint(dataLocationConstraint);
        return this;
    }

    public ResiliencyPolicy withDataLocationConstraint(DataLocationConstraint dataLocationConstraint) {
        this.dataLocationConstraint = dataLocationConstraint.toString();
        return this;
    }

    public void setEstimatedCostTier(String estimatedCostTier) {
        this.estimatedCostTier = estimatedCostTier;
    }

    public String getEstimatedCostTier() {
        return this.estimatedCostTier;
    }

    public ResiliencyPolicy withEstimatedCostTier(String estimatedCostTier) {
        this.setEstimatedCostTier(estimatedCostTier);
        return this;
    }

    public ResiliencyPolicy withEstimatedCostTier(EstimatedCostTier estimatedCostTier) {
        this.estimatedCostTier = estimatedCostTier.toString();
        return this;
    }

    public Map<String, FailurePolicy> getPolicy() {
        return this.policy;
    }

    public void setPolicy(Map<String, FailurePolicy> policy) {
        this.policy = policy;
    }

    public ResiliencyPolicy withPolicy(Map<String, FailurePolicy> policy) {
        this.setPolicy(policy);
        return this;
    }

    public ResiliencyPolicy addPolicyEntry(String key, FailurePolicy value) {
        if (null == this.policy) {
            this.policy = new HashMap<String, FailurePolicy>();
        }
        if (this.policy.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.policy.put(key, value);
        return this;
    }

    public ResiliencyPolicy clearPolicyEntries() {
        this.policy = null;
        return this;
    }

    public void setPolicyArn(String policyArn) {
        this.policyArn = policyArn;
    }

    public String getPolicyArn() {
        return this.policyArn;
    }

    public ResiliencyPolicy withPolicyArn(String policyArn) {
        this.setPolicyArn(policyArn);
        return this;
    }

    public void setPolicyDescription(String policyDescription) {
        this.policyDescription = policyDescription;
    }

    public String getPolicyDescription() {
        return this.policyDescription;
    }

    public ResiliencyPolicy withPolicyDescription(String policyDescription) {
        this.setPolicyDescription(policyDescription);
        return this;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public ResiliencyPolicy withPolicyName(String policyName) {
        this.setPolicyName(policyName);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ResiliencyPolicy withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ResiliencyPolicy addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ResiliencyPolicy clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public ResiliencyPolicy withTier(String tier) {
        this.setTier(tier);
        return this;
    }

    public ResiliencyPolicy withTier(ResiliencyPolicyTier tier) {
        this.tier = tier.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getDataLocationConstraint() != null) {
            sb.append("DataLocationConstraint: ").append(this.getDataLocationConstraint()).append(",");
        }
        if (this.getEstimatedCostTier() != null) {
            sb.append("EstimatedCostTier: ").append(this.getEstimatedCostTier()).append(",");
        }
        if (this.getPolicy() != null) {
            sb.append("Policy: ").append(this.getPolicy()).append(",");
        }
        if (this.getPolicyArn() != null) {
            sb.append("PolicyArn: ").append(this.getPolicyArn()).append(",");
        }
        if (this.getPolicyDescription() != null) {
            sb.append("PolicyDescription: ").append(this.getPolicyDescription()).append(",");
        }
        if (this.getPolicyName() != null) {
            sb.append("PolicyName: ").append(this.getPolicyName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResiliencyPolicy)) {
            return false;
        }
        ResiliencyPolicy other = (ResiliencyPolicy)obj;
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getDataLocationConstraint() == null ^ this.getDataLocationConstraint() == null) {
            return false;
        }
        if (other.getDataLocationConstraint() != null && !other.getDataLocationConstraint().equals(this.getDataLocationConstraint())) {
            return false;
        }
        if (other.getEstimatedCostTier() == null ^ this.getEstimatedCostTier() == null) {
            return false;
        }
        if (other.getEstimatedCostTier() != null && !other.getEstimatedCostTier().equals(this.getEstimatedCostTier())) {
            return false;
        }
        if (other.getPolicy() == null ^ this.getPolicy() == null) {
            return false;
        }
        if (other.getPolicy() != null && !other.getPolicy().equals(this.getPolicy())) {
            return false;
        }
        if (other.getPolicyArn() == null ^ this.getPolicyArn() == null) {
            return false;
        }
        if (other.getPolicyArn() != null && !other.getPolicyArn().equals(this.getPolicyArn())) {
            return false;
        }
        if (other.getPolicyDescription() == null ^ this.getPolicyDescription() == null) {
            return false;
        }
        if (other.getPolicyDescription() != null && !other.getPolicyDescription().equals(this.getPolicyDescription())) {
            return false;
        }
        if (other.getPolicyName() == null ^ this.getPolicyName() == null) {
            return false;
        }
        if (other.getPolicyName() != null && !other.getPolicyName().equals(this.getPolicyName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        return other.getTier() == null || other.getTier().equals(this.getTier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getDataLocationConstraint() == null ? 0 : this.getDataLocationConstraint().hashCode());
        hashCode = 31 * hashCode + (this.getEstimatedCostTier() == null ? 0 : this.getEstimatedCostTier().hashCode());
        hashCode = 31 * hashCode + (this.getPolicy() == null ? 0 : this.getPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyArn() == null ? 0 : this.getPolicyArn().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyDescription() == null ? 0 : this.getPolicyDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyName() == null ? 0 : this.getPolicyName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        return hashCode;
    }

    public ResiliencyPolicy clone() {
        try {
            return (ResiliencyPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResiliencyPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

