/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.FaceDetail;
import com.amazonaws.services.rekognition.model.UnsearchedFaceReason;
import com.amazonaws.services.rekognition.model.transform.UnsearchedFaceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnsearchedFace
implements Serializable,
Cloneable,
StructuredPojo {
    private FaceDetail faceDetails;
    private List<String> reasons;

    public void setFaceDetails(FaceDetail faceDetails) {
        this.faceDetails = faceDetails;
    }

    public FaceDetail getFaceDetails() {
        return this.faceDetails;
    }

    public UnsearchedFace withFaceDetails(FaceDetail faceDetails) {
        this.setFaceDetails(faceDetails);
        return this;
    }

    public List<String> getReasons() {
        return this.reasons;
    }

    public void setReasons(Collection<String> reasons) {
        if (reasons == null) {
            this.reasons = null;
            return;
        }
        this.reasons = new ArrayList<String>(reasons);
    }

    public UnsearchedFace withReasons(String ... reasons) {
        if (this.reasons == null) {
            this.setReasons(new ArrayList<String>(reasons.length));
        }
        for (String ele : reasons) {
            this.reasons.add(ele);
        }
        return this;
    }

    public UnsearchedFace withReasons(Collection<String> reasons) {
        this.setReasons(reasons);
        return this;
    }

    public UnsearchedFace withReasons(UnsearchedFaceReason ... reasons) {
        ArrayList<String> reasonsCopy = new ArrayList<String>(reasons.length);
        for (UnsearchedFaceReason value : reasons) {
            reasonsCopy.add(value.toString());
        }
        if (this.getReasons() == null) {
            this.setReasons(reasonsCopy);
        } else {
            this.getReasons().addAll(reasonsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFaceDetails() != null) {
            sb.append("FaceDetails: ").append(this.getFaceDetails()).append(",");
        }
        if (this.getReasons() != null) {
            sb.append("Reasons: ").append(this.getReasons());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsearchedFace)) {
            return false;
        }
        UnsearchedFace other = (UnsearchedFace)obj;
        if (other.getFaceDetails() == null ^ this.getFaceDetails() == null) {
            return false;
        }
        if (other.getFaceDetails() != null && !other.getFaceDetails().equals(this.getFaceDetails())) {
            return false;
        }
        if (other.getReasons() == null ^ this.getReasons() == null) {
            return false;
        }
        return other.getReasons() == null || other.getReasons().equals(this.getReasons());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFaceDetails() == null ? 0 : this.getFaceDetails().hashCode());
        hashCode = 31 * hashCode + (this.getReasons() == null ? 0 : this.getReasons().hashCode());
        return hashCode;
    }

    public UnsearchedFace clone() {
        try {
            return (UnsearchedFace)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UnsearchedFaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

