/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rekognition.model.LabelDetectionFeatureName;
import com.amazonaws.services.rekognition.model.LabelDetectionSettings;
import com.amazonaws.services.rekognition.model.NotificationChannel;
import com.amazonaws.services.rekognition.model.Video;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartLabelDetectionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Video video;
    private String clientRequestToken;
    private Float minConfidence;
    private NotificationChannel notificationChannel;
    private String jobTag;
    private List<String> features;
    private LabelDetectionSettings settings;

    public void setVideo(Video video) {
        this.video = video;
    }

    public Video getVideo() {
        return this.video;
    }

    public StartLabelDetectionRequest withVideo(Video video) {
        this.setVideo(video);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public StartLabelDetectionRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setMinConfidence(Float minConfidence) {
        this.minConfidence = minConfidence;
    }

    public Float getMinConfidence() {
        return this.minConfidence;
    }

    public StartLabelDetectionRequest withMinConfidence(Float minConfidence) {
        this.setMinConfidence(minConfidence);
        return this;
    }

    public void setNotificationChannel(NotificationChannel notificationChannel) {
        this.notificationChannel = notificationChannel;
    }

    public NotificationChannel getNotificationChannel() {
        return this.notificationChannel;
    }

    public StartLabelDetectionRequest withNotificationChannel(NotificationChannel notificationChannel) {
        this.setNotificationChannel(notificationChannel);
        return this;
    }

    public void setJobTag(String jobTag) {
        this.jobTag = jobTag;
    }

    public String getJobTag() {
        return this.jobTag;
    }

    public StartLabelDetectionRequest withJobTag(String jobTag) {
        this.setJobTag(jobTag);
        return this;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<String> features) {
        if (features == null) {
            this.features = null;
            return;
        }
        this.features = new ArrayList<String>(features);
    }

    public StartLabelDetectionRequest withFeatures(String ... features) {
        if (this.features == null) {
            this.setFeatures(new ArrayList<String>(features.length));
        }
        for (String ele : features) {
            this.features.add(ele);
        }
        return this;
    }

    public StartLabelDetectionRequest withFeatures(Collection<String> features) {
        this.setFeatures(features);
        return this;
    }

    public StartLabelDetectionRequest withFeatures(LabelDetectionFeatureName ... features) {
        ArrayList<String> featuresCopy = new ArrayList<String>(features.length);
        for (LabelDetectionFeatureName value : features) {
            featuresCopy.add(value.toString());
        }
        if (this.getFeatures() == null) {
            this.setFeatures(featuresCopy);
        } else {
            this.getFeatures().addAll(featuresCopy);
        }
        return this;
    }

    public void setSettings(LabelDetectionSettings settings) {
        this.settings = settings;
    }

    public LabelDetectionSettings getSettings() {
        return this.settings;
    }

    public StartLabelDetectionRequest withSettings(LabelDetectionSettings settings) {
        this.setSettings(settings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVideo() != null) {
            sb.append("Video: ").append(this.getVideo()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getMinConfidence() != null) {
            sb.append("MinConfidence: ").append(this.getMinConfidence()).append(",");
        }
        if (this.getNotificationChannel() != null) {
            sb.append("NotificationChannel: ").append(this.getNotificationChannel()).append(",");
        }
        if (this.getJobTag() != null) {
            sb.append("JobTag: ").append(this.getJobTag()).append(",");
        }
        if (this.getFeatures() != null) {
            sb.append("Features: ").append(this.getFeatures()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLabelDetectionRequest)) {
            return false;
        }
        StartLabelDetectionRequest other = (StartLabelDetectionRequest)obj;
        if (other.getVideo() == null ^ this.getVideo() == null) {
            return false;
        }
        if (other.getVideo() != null && !other.getVideo().equals(this.getVideo())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getMinConfidence() == null ^ this.getMinConfidence() == null) {
            return false;
        }
        if (other.getMinConfidence() != null && !other.getMinConfidence().equals(this.getMinConfidence())) {
            return false;
        }
        if (other.getNotificationChannel() == null ^ this.getNotificationChannel() == null) {
            return false;
        }
        if (other.getNotificationChannel() != null && !other.getNotificationChannel().equals(this.getNotificationChannel())) {
            return false;
        }
        if (other.getJobTag() == null ^ this.getJobTag() == null) {
            return false;
        }
        if (other.getJobTag() != null && !other.getJobTag().equals(this.getJobTag())) {
            return false;
        }
        if (other.getFeatures() == null ^ this.getFeatures() == null) {
            return false;
        }
        if (other.getFeatures() != null && !other.getFeatures().equals(this.getFeatures())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        return other.getSettings() == null || other.getSettings().equals(this.getSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVideo() == null ? 0 : this.getVideo().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getMinConfidence() == null ? 0 : this.getMinConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationChannel() == null ? 0 : this.getNotificationChannel().hashCode());
        hashCode = 31 * hashCode + (this.getJobTag() == null ? 0 : this.getJobTag().hashCode());
        hashCode = 31 * hashCode + (this.getFeatures() == null ? 0 : this.getFeatures().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        return hashCode;
    }

    public StartLabelDetectionRequest clone() {
        return (StartLabelDetectionRequest)super.clone();
    }
}

