/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.DatasetMetadata;
import com.amazonaws.services.rekognition.model.ProjectStatus;
import com.amazonaws.services.rekognition.model.transform.ProjectDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ProjectDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String projectArn;
    private Date creationTimestamp;
    private String status;
    private List<DatasetMetadata> datasets;

    public void setProjectArn(String projectArn) {
        this.projectArn = projectArn;
    }

    public String getProjectArn() {
        return this.projectArn;
    }

    public ProjectDescription withProjectArn(String projectArn) {
        this.setProjectArn(projectArn);
        return this;
    }

    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public ProjectDescription withCreationTimestamp(Date creationTimestamp) {
        this.setCreationTimestamp(creationTimestamp);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ProjectDescription withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ProjectDescription withStatus(ProjectStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<DatasetMetadata> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(Collection<DatasetMetadata> datasets) {
        if (datasets == null) {
            this.datasets = null;
            return;
        }
        this.datasets = new ArrayList<DatasetMetadata>(datasets);
    }

    public ProjectDescription withDatasets(DatasetMetadata ... datasets) {
        if (this.datasets == null) {
            this.setDatasets(new ArrayList<DatasetMetadata>(datasets.length));
        }
        for (DatasetMetadata ele : datasets) {
            this.datasets.add(ele);
        }
        return this;
    }

    public ProjectDescription withDatasets(Collection<DatasetMetadata> datasets) {
        this.setDatasets(datasets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProjectArn() != null) {
            sb.append("ProjectArn: ").append(this.getProjectArn()).append(",");
        }
        if (this.getCreationTimestamp() != null) {
            sb.append("CreationTimestamp: ").append(this.getCreationTimestamp()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getDatasets() != null) {
            sb.append("Datasets: ").append(this.getDatasets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDescription)) {
            return false;
        }
        ProjectDescription other = (ProjectDescription)obj;
        if (other.getProjectArn() == null ^ this.getProjectArn() == null) {
            return false;
        }
        if (other.getProjectArn() != null && !other.getProjectArn().equals(this.getProjectArn())) {
            return false;
        }
        if (other.getCreationTimestamp() == null ^ this.getCreationTimestamp() == null) {
            return false;
        }
        if (other.getCreationTimestamp() != null && !other.getCreationTimestamp().equals(this.getCreationTimestamp())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDatasets() == null ^ this.getDatasets() == null) {
            return false;
        }
        return other.getDatasets() == null || other.getDatasets().equals(this.getDatasets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProjectArn() == null ? 0 : this.getProjectArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTimestamp() == null ? 0 : this.getCreationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDatasets() == null ? 0 : this.getDatasets().hashCode());
        return hashCode;
    }

    public ProjectDescription clone() {
        try {
            return (ProjectDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

