/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Image;
import com.amazonaws.services.rekognition.model.transform.S3ObjectJsonMarshaller;

public class ImageJsonMarshaller {
    private static ImageJsonMarshaller instance;

    public void marshall(Image image, StructuredJsonGenerator jsonGenerator) {
        if (image == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (image.getBytes() != null) {
                jsonGenerator.writeFieldName("Bytes").writeValue(image.getBytes());
            }
            if (image.getS3Object() != null) {
                jsonGenerator.writeFieldName("S3Object");
                S3ObjectJsonMarshaller.getInstance().marshall(image.getS3Object(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageJsonMarshaller();
        }
        return instance;
    }
}

