/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.ClusterNode;
import com.amazonaws.services.redshift.model.ClusterParameterGroupStatus;
import com.amazonaws.services.redshift.model.ClusterSecurityGroupMembership;
import com.amazonaws.services.redshift.model.ClusterSnapshotCopyStatus;
import com.amazonaws.services.redshift.model.ElasticIpStatus;
import com.amazonaws.services.redshift.model.Endpoint;
import com.amazonaws.services.redshift.model.HsmStatus;
import com.amazonaws.services.redshift.model.PendingModifiedValues;
import com.amazonaws.services.redshift.model.RestoreStatus;
import com.amazonaws.services.redshift.model.VpcSecurityGroupMembership;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Cluster
implements Serializable {
    private String clusterIdentifier;
    private String nodeType;
    private String clusterStatus;
    private String modifyStatus;
    private String masterUsername;
    private String dBName;
    private Endpoint endpoint;
    private Date clusterCreateTime;
    private Integer automatedSnapshotRetentionPeriod;
    private ListWithAutoConstructFlag<ClusterSecurityGroupMembership> clusterSecurityGroups;
    private ListWithAutoConstructFlag<VpcSecurityGroupMembership> vpcSecurityGroups;
    private ListWithAutoConstructFlag<ClusterParameterGroupStatus> clusterParameterGroups;
    private String clusterSubnetGroupName;
    private String vpcId;
    private String availabilityZone;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private String clusterVersion;
    private Boolean allowVersionUpgrade;
    private Integer numberOfNodes;
    private Boolean publiclyAccessible;
    private Boolean encrypted;
    private RestoreStatus restoreStatus;
    private HsmStatus hsmStatus;
    private ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;
    private String clusterPublicKey;
    private ListWithAutoConstructFlag<ClusterNode> clusterNodes;
    private ElasticIpStatus elasticIpStatus;
    private String clusterRevisionNumber;

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public Cluster withClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
        return this;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public Cluster withNodeType(String nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public String getClusterStatus() {
        return this.clusterStatus;
    }

    public void setClusterStatus(String clusterStatus) {
        this.clusterStatus = clusterStatus;
    }

    public Cluster withClusterStatus(String clusterStatus) {
        this.clusterStatus = clusterStatus;
        return this;
    }

    public String getModifyStatus() {
        return this.modifyStatus;
    }

    public void setModifyStatus(String modifyStatus) {
        this.modifyStatus = modifyStatus;
    }

    public Cluster withModifyStatus(String modifyStatus) {
        this.modifyStatus = modifyStatus;
        return this;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public Cluster withMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
        return this;
    }

    public String getDBName() {
        return this.dBName;
    }

    public void setDBName(String dBName) {
        this.dBName = dBName;
    }

    public Cluster withDBName(String dBName) {
        this.dBName = dBName;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Cluster withEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Date getClusterCreateTime() {
        return this.clusterCreateTime;
    }

    public void setClusterCreateTime(Date clusterCreateTime) {
        this.clusterCreateTime = clusterCreateTime;
    }

    public Cluster withClusterCreateTime(Date clusterCreateTime) {
        this.clusterCreateTime = clusterCreateTime;
        return this;
    }

    public Integer getAutomatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
    }

    public Cluster withAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        return this;
    }

    public List<ClusterSecurityGroupMembership> getClusterSecurityGroups() {
        if (this.clusterSecurityGroups == null) {
            this.clusterSecurityGroups = new ListWithAutoConstructFlag();
            this.clusterSecurityGroups.setAutoConstruct(true);
        }
        return this.clusterSecurityGroups;
    }

    public void setClusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups) {
        if (clusterSecurityGroups == null) {
            this.clusterSecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag clusterSecurityGroupsCopy = new ListWithAutoConstructFlag(clusterSecurityGroups.size());
        clusterSecurityGroupsCopy.addAll(clusterSecurityGroups);
        this.clusterSecurityGroups = clusterSecurityGroupsCopy;
    }

    public Cluster withClusterSecurityGroups(ClusterSecurityGroupMembership ... clusterSecurityGroups) {
        if (this.getClusterSecurityGroups() == null) {
            this.setClusterSecurityGroups(new ArrayList<ClusterSecurityGroupMembership>(clusterSecurityGroups.length));
        }
        for (ClusterSecurityGroupMembership value : clusterSecurityGroups) {
            this.getClusterSecurityGroups().add(value);
        }
        return this;
    }

    public Cluster withClusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups) {
        if (clusterSecurityGroups == null) {
            this.clusterSecurityGroups = null;
        } else {
            ListWithAutoConstructFlag clusterSecurityGroupsCopy = new ListWithAutoConstructFlag(clusterSecurityGroups.size());
            clusterSecurityGroupsCopy.addAll(clusterSecurityGroups);
            this.clusterSecurityGroups = clusterSecurityGroupsCopy;
        }
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        if (this.vpcSecurityGroups == null) {
            this.vpcSecurityGroups = new ListWithAutoConstructFlag();
            this.vpcSecurityGroups.setAutoConstruct(true);
        }
        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag vpcSecurityGroupsCopy = new ListWithAutoConstructFlag(vpcSecurityGroups.size());
        vpcSecurityGroupsCopy.addAll(vpcSecurityGroups);
        this.vpcSecurityGroups = vpcSecurityGroupsCopy;
    }

    public Cluster withVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
        if (this.getVpcSecurityGroups() == null) {
            this.setVpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroups.length));
        }
        for (VpcSecurityGroupMembership value : vpcSecurityGroups) {
            this.getVpcSecurityGroups().add(value);
        }
        return this;
    }

    public Cluster withVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
        } else {
            ListWithAutoConstructFlag vpcSecurityGroupsCopy = new ListWithAutoConstructFlag(vpcSecurityGroups.size());
            vpcSecurityGroupsCopy.addAll(vpcSecurityGroups);
            this.vpcSecurityGroups = vpcSecurityGroupsCopy;
        }
        return this;
    }

    public List<ClusterParameterGroupStatus> getClusterParameterGroups() {
        if (this.clusterParameterGroups == null) {
            this.clusterParameterGroups = new ListWithAutoConstructFlag();
            this.clusterParameterGroups.setAutoConstruct(true);
        }
        return this.clusterParameterGroups;
    }

    public void setClusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups) {
        if (clusterParameterGroups == null) {
            this.clusterParameterGroups = null;
            return;
        }
        ListWithAutoConstructFlag clusterParameterGroupsCopy = new ListWithAutoConstructFlag(clusterParameterGroups.size());
        clusterParameterGroupsCopy.addAll(clusterParameterGroups);
        this.clusterParameterGroups = clusterParameterGroupsCopy;
    }

    public Cluster withClusterParameterGroups(ClusterParameterGroupStatus ... clusterParameterGroups) {
        if (this.getClusterParameterGroups() == null) {
            this.setClusterParameterGroups(new ArrayList<ClusterParameterGroupStatus>(clusterParameterGroups.length));
        }
        for (ClusterParameterGroupStatus value : clusterParameterGroups) {
            this.getClusterParameterGroups().add(value);
        }
        return this;
    }

    public Cluster withClusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups) {
        if (clusterParameterGroups == null) {
            this.clusterParameterGroups = null;
        } else {
            ListWithAutoConstructFlag clusterParameterGroupsCopy = new ListWithAutoConstructFlag(clusterParameterGroups.size());
            clusterParameterGroupsCopy.addAll(clusterParameterGroups);
            this.clusterParameterGroups = clusterParameterGroupsCopy;
        }
        return this;
    }

    public String getClusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public void setClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
    }

    public Cluster withClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public Cluster withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public Cluster withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public Cluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public Cluster withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
        return this;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public Cluster withClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
        return this;
    }

    public Boolean isAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.allowVersionUpgrade = allowVersionUpgrade;
    }

    public Cluster withAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.allowVersionUpgrade = allowVersionUpgrade;
        return this;
    }

    public Boolean getAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    public Cluster withNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Cluster withPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
        return this;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Cluster withEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public RestoreStatus getRestoreStatus() {
        return this.restoreStatus;
    }

    public void setRestoreStatus(RestoreStatus restoreStatus) {
        this.restoreStatus = restoreStatus;
    }

    public Cluster withRestoreStatus(RestoreStatus restoreStatus) {
        this.restoreStatus = restoreStatus;
        return this;
    }

    public HsmStatus getHsmStatus() {
        return this.hsmStatus;
    }

    public void setHsmStatus(HsmStatus hsmStatus) {
        this.hsmStatus = hsmStatus;
    }

    public Cluster withHsmStatus(HsmStatus hsmStatus) {
        this.hsmStatus = hsmStatus;
        return this;
    }

    public ClusterSnapshotCopyStatus getClusterSnapshotCopyStatus() {
        return this.clusterSnapshotCopyStatus;
    }

    public void setClusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
        this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus;
    }

    public Cluster withClusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
        this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus;
        return this;
    }

    public String getClusterPublicKey() {
        return this.clusterPublicKey;
    }

    public void setClusterPublicKey(String clusterPublicKey) {
        this.clusterPublicKey = clusterPublicKey;
    }

    public Cluster withClusterPublicKey(String clusterPublicKey) {
        this.clusterPublicKey = clusterPublicKey;
        return this;
    }

    public List<ClusterNode> getClusterNodes() {
        if (this.clusterNodes == null) {
            this.clusterNodes = new ListWithAutoConstructFlag();
            this.clusterNodes.setAutoConstruct(true);
        }
        return this.clusterNodes;
    }

    public void setClusterNodes(Collection<ClusterNode> clusterNodes) {
        if (clusterNodes == null) {
            this.clusterNodes = null;
            return;
        }
        ListWithAutoConstructFlag clusterNodesCopy = new ListWithAutoConstructFlag(clusterNodes.size());
        clusterNodesCopy.addAll(clusterNodes);
        this.clusterNodes = clusterNodesCopy;
    }

    public Cluster withClusterNodes(ClusterNode ... clusterNodes) {
        if (this.getClusterNodes() == null) {
            this.setClusterNodes(new ArrayList<ClusterNode>(clusterNodes.length));
        }
        for (ClusterNode value : clusterNodes) {
            this.getClusterNodes().add(value);
        }
        return this;
    }

    public Cluster withClusterNodes(Collection<ClusterNode> clusterNodes) {
        if (clusterNodes == null) {
            this.clusterNodes = null;
        } else {
            ListWithAutoConstructFlag clusterNodesCopy = new ListWithAutoConstructFlag(clusterNodes.size());
            clusterNodesCopy.addAll(clusterNodes);
            this.clusterNodes = clusterNodesCopy;
        }
        return this;
    }

    public ElasticIpStatus getElasticIpStatus() {
        return this.elasticIpStatus;
    }

    public void setElasticIpStatus(ElasticIpStatus elasticIpStatus) {
        this.elasticIpStatus = elasticIpStatus;
    }

    public Cluster withElasticIpStatus(ElasticIpStatus elasticIpStatus) {
        this.elasticIpStatus = elasticIpStatus;
        return this;
    }

    public String getClusterRevisionNumber() {
        return this.clusterRevisionNumber;
    }

    public void setClusterRevisionNumber(String clusterRevisionNumber) {
        this.clusterRevisionNumber = clusterRevisionNumber;
    }

    public Cluster withClusterRevisionNumber(String clusterRevisionNumber) {
        this.clusterRevisionNumber = clusterRevisionNumber;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: " + this.getClusterIdentifier() + ",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: " + this.getNodeType() + ",");
        }
        if (this.getClusterStatus() != null) {
            sb.append("ClusterStatus: " + this.getClusterStatus() + ",");
        }
        if (this.getModifyStatus() != null) {
            sb.append("ModifyStatus: " + this.getModifyStatus() + ",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: " + this.getMasterUsername() + ",");
        }
        if (this.getDBName() != null) {
            sb.append("DBName: " + this.getDBName() + ",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: " + this.getEndpoint() + ",");
        }
        if (this.getClusterCreateTime() != null) {
            sb.append("ClusterCreateTime: " + this.getClusterCreateTime() + ",");
        }
        if (this.getAutomatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: " + this.getAutomatedSnapshotRetentionPeriod() + ",");
        }
        if (this.getClusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: " + this.getClusterSecurityGroups() + ",");
        }
        if (this.getVpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: " + this.getVpcSecurityGroups() + ",");
        }
        if (this.getClusterParameterGroups() != null) {
            sb.append("ClusterParameterGroups: " + this.getClusterParameterGroups() + ",");
        }
        if (this.getClusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: " + this.getClusterSubnetGroupName() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: " + this.getPendingModifiedValues() + ",");
        }
        if (this.getClusterVersion() != null) {
            sb.append("ClusterVersion: " + this.getClusterVersion() + ",");
        }
        if (this.isAllowVersionUpgrade() != null) {
            sb.append("AllowVersionUpgrade: " + this.isAllowVersionUpgrade() + ",");
        }
        if (this.getNumberOfNodes() != null) {
            sb.append("NumberOfNodes: " + this.getNumberOfNodes() + ",");
        }
        if (this.isPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: " + this.isPubliclyAccessible() + ",");
        }
        if (this.isEncrypted() != null) {
            sb.append("Encrypted: " + this.isEncrypted() + ",");
        }
        if (this.getRestoreStatus() != null) {
            sb.append("RestoreStatus: " + this.getRestoreStatus() + ",");
        }
        if (this.getHsmStatus() != null) {
            sb.append("HsmStatus: " + this.getHsmStatus() + ",");
        }
        if (this.getClusterSnapshotCopyStatus() != null) {
            sb.append("ClusterSnapshotCopyStatus: " + this.getClusterSnapshotCopyStatus() + ",");
        }
        if (this.getClusterPublicKey() != null) {
            sb.append("ClusterPublicKey: " + this.getClusterPublicKey() + ",");
        }
        if (this.getClusterNodes() != null) {
            sb.append("ClusterNodes: " + this.getClusterNodes() + ",");
        }
        if (this.getElasticIpStatus() != null) {
            sb.append("ElasticIpStatus: " + this.getElasticIpStatus() + ",");
        }
        if (this.getClusterRevisionNumber() != null) {
            sb.append("ClusterRevisionNumber: " + this.getClusterRevisionNumber());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getClusterStatus() == null ? 0 : this.getClusterStatus().hashCode());
        hashCode = 31 * hashCode + (this.getModifyStatus() == null ? 0 : this.getModifyStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getDBName() == null ? 0 : this.getDBName().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getClusterCreateTime() == null ? 0 : this.getClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getAutomatedSnapshotRetentionPeriod() == null ? 0 : this.getAutomatedSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSecurityGroups() == null ? 0 : this.getClusterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroups() == null ? 0 : this.getVpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getClusterParameterGroups() == null ? 0 : this.getClusterParameterGroups().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSubnetGroupName() == null ? 0 : this.getClusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getClusterVersion() == null ? 0 : this.getClusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.isAllowVersionUpgrade() == null ? 0 : this.isAllowVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfNodes() == null ? 0 : this.getNumberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.isPubliclyAccessible() == null ? 0 : this.isPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.isEncrypted() == null ? 0 : this.isEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getRestoreStatus() == null ? 0 : this.getRestoreStatus().hashCode());
        hashCode = 31 * hashCode + (this.getHsmStatus() == null ? 0 : this.getHsmStatus().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSnapshotCopyStatus() == null ? 0 : this.getClusterSnapshotCopyStatus().hashCode());
        hashCode = 31 * hashCode + (this.getClusterPublicKey() == null ? 0 : this.getClusterPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.getClusterNodes() == null ? 0 : this.getClusterNodes().hashCode());
        hashCode = 31 * hashCode + (this.getElasticIpStatus() == null ? 0 : this.getElasticIpStatus().hashCode());
        hashCode = 31 * hashCode + (this.getClusterRevisionNumber() == null ? 0 : this.getClusterRevisionNumber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getClusterStatus() == null ^ this.getClusterStatus() == null) {
            return false;
        }
        if (other.getClusterStatus() != null && !other.getClusterStatus().equals(this.getClusterStatus())) {
            return false;
        }
        if (other.getModifyStatus() == null ^ this.getModifyStatus() == null) {
            return false;
        }
        if (other.getModifyStatus() != null && !other.getModifyStatus().equals(this.getModifyStatus())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getDBName() == null ^ this.getDBName() == null) {
            return false;
        }
        if (other.getDBName() != null && !other.getDBName().equals(this.getDBName())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getClusterCreateTime() == null ^ this.getClusterCreateTime() == null) {
            return false;
        }
        if (other.getClusterCreateTime() != null && !other.getClusterCreateTime().equals(this.getClusterCreateTime())) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() == null ^ this.getAutomatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() != null && !other.getAutomatedSnapshotRetentionPeriod().equals(this.getAutomatedSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.getClusterSecurityGroups() == null ^ this.getClusterSecurityGroups() == null) {
            return false;
        }
        if (other.getClusterSecurityGroups() != null && !other.getClusterSecurityGroups().equals(this.getClusterSecurityGroups())) {
            return false;
        }
        if (other.getVpcSecurityGroups() == null ^ this.getVpcSecurityGroups() == null) {
            return false;
        }
        if (other.getVpcSecurityGroups() != null && !other.getVpcSecurityGroups().equals(this.getVpcSecurityGroups())) {
            return false;
        }
        if (other.getClusterParameterGroups() == null ^ this.getClusterParameterGroups() == null) {
            return false;
        }
        if (other.getClusterParameterGroups() != null && !other.getClusterParameterGroups().equals(this.getClusterParameterGroups())) {
            return false;
        }
        if (other.getClusterSubnetGroupName() == null ^ this.getClusterSubnetGroupName() == null) {
            return false;
        }
        if (other.getClusterSubnetGroupName() != null && !other.getClusterSubnetGroupName().equals(this.getClusterSubnetGroupName())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getClusterVersion() == null ^ this.getClusterVersion() == null) {
            return false;
        }
        if (other.getClusterVersion() != null && !other.getClusterVersion().equals(this.getClusterVersion())) {
            return false;
        }
        if (other.isAllowVersionUpgrade() == null ^ this.isAllowVersionUpgrade() == null) {
            return false;
        }
        if (other.isAllowVersionUpgrade() != null && !other.isAllowVersionUpgrade().equals(this.isAllowVersionUpgrade())) {
            return false;
        }
        if (other.getNumberOfNodes() == null ^ this.getNumberOfNodes() == null) {
            return false;
        }
        if (other.getNumberOfNodes() != null && !other.getNumberOfNodes().equals(this.getNumberOfNodes())) {
            return false;
        }
        if (other.isPubliclyAccessible() == null ^ this.isPubliclyAccessible() == null) {
            return false;
        }
        if (other.isPubliclyAccessible() != null && !other.isPubliclyAccessible().equals(this.isPubliclyAccessible())) {
            return false;
        }
        if (other.isEncrypted() == null ^ this.isEncrypted() == null) {
            return false;
        }
        if (other.isEncrypted() != null && !other.isEncrypted().equals(this.isEncrypted())) {
            return false;
        }
        if (other.getRestoreStatus() == null ^ this.getRestoreStatus() == null) {
            return false;
        }
        if (other.getRestoreStatus() != null && !other.getRestoreStatus().equals(this.getRestoreStatus())) {
            return false;
        }
        if (other.getHsmStatus() == null ^ this.getHsmStatus() == null) {
            return false;
        }
        if (other.getHsmStatus() != null && !other.getHsmStatus().equals(this.getHsmStatus())) {
            return false;
        }
        if (other.getClusterSnapshotCopyStatus() == null ^ this.getClusterSnapshotCopyStatus() == null) {
            return false;
        }
        if (other.getClusterSnapshotCopyStatus() != null && !other.getClusterSnapshotCopyStatus().equals(this.getClusterSnapshotCopyStatus())) {
            return false;
        }
        if (other.getClusterPublicKey() == null ^ this.getClusterPublicKey() == null) {
            return false;
        }
        if (other.getClusterPublicKey() != null && !other.getClusterPublicKey().equals(this.getClusterPublicKey())) {
            return false;
        }
        if (other.getClusterNodes() == null ^ this.getClusterNodes() == null) {
            return false;
        }
        if (other.getClusterNodes() != null && !other.getClusterNodes().equals(this.getClusterNodes())) {
            return false;
        }
        if (other.getElasticIpStatus() == null ^ this.getElasticIpStatus() == null) {
            return false;
        }
        if (other.getElasticIpStatus() != null && !other.getElasticIpStatus().equals(this.getElasticIpStatus())) {
            return false;
        }
        if (other.getClusterRevisionNumber() == null ^ this.getClusterRevisionNumber() == null) {
            return false;
        }
        return other.getClusterRevisionNumber() == null || other.getClusterRevisionNumber().equals(this.getClusterRevisionNumber());
    }
}

