/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.ResourcePolicy;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ResourcePolicyStaxUnmarshaller
implements Unmarshaller<ResourcePolicy, StaxUnmarshallerContext> {
    private static ResourcePolicyStaxUnmarshaller instance;

    public ResourcePolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourcePolicy resourcePolicy = new ResourcePolicy();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourcePolicy;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ResourceArn", targetDepth)) {
                    resourcePolicy.setResourceArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Policy", targetDepth)) continue;
                resourcePolicy.setPolicy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourcePolicy;
    }

    public static ResourcePolicyStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourcePolicyStaxUnmarshaller();
        }
        return instance;
    }
}

