/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.DescribeSnapshotSchedulesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSnapshotSchedulesRequestMarshaller
implements Marshaller<Request<DescribeSnapshotSchedulesRequest>, DescribeSnapshotSchedulesRequest> {
    public Request<DescribeSnapshotSchedulesRequest> marshall(DescribeSnapshotSchedulesRequest describeSnapshotSchedulesRequest) {
        if (describeSnapshotSchedulesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSnapshotSchedulesRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeSnapshotSchedules");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSnapshotSchedulesRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)describeSnapshotSchedulesRequest.getClusterIdentifier()));
        }
        if (describeSnapshotSchedulesRequest.getScheduleIdentifier() != null) {
            request.addParameter("ScheduleIdentifier", StringUtils.fromString((String)describeSnapshotSchedulesRequest.getScheduleIdentifier()));
        }
        if (!describeSnapshotSchedulesRequest.getTagKeys().isEmpty() || !((SdkInternalList)describeSnapshotSchedulesRequest.getTagKeys()).isAutoConstruct()) {
            SdkInternalList tagKeysList = (SdkInternalList)describeSnapshotSchedulesRequest.getTagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!describeSnapshotSchedulesRequest.getTagValues().isEmpty() || !((SdkInternalList)describeSnapshotSchedulesRequest.getTagValues()).isAutoConstruct()) {
            SdkInternalList tagValuesList = (SdkInternalList)describeSnapshotSchedulesRequest.getTagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        if (describeSnapshotSchedulesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeSnapshotSchedulesRequest.getMarker()));
        }
        if (describeSnapshotSchedulesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeSnapshotSchedulesRequest.getMaxRecords()));
        }
        return request;
    }
}

