/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.AccountAttribute;
import com.amazonaws.services.redshift.model.AttributeValueTarget;
import com.amazonaws.services.redshift.model.transform.AttributeValueTargetStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class AccountAttributeStaxUnmarshaller
implements Unmarshaller<AccountAttribute, StaxUnmarshallerContext> {
    private static AccountAttributeStaxUnmarshaller instance;

    public AccountAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        AccountAttribute accountAttribute = new AccountAttribute();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return accountAttribute;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AttributeName", targetDepth)) {
                    accountAttribute.setAttributeName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AttributeValues", targetDepth)) {
                    accountAttribute.withAttributeValues(new ArrayList<AttributeValueTarget>());
                    continue;
                }
                if (!context.testExpression("AttributeValues/AttributeValueTarget", targetDepth)) continue;
                accountAttribute.withAttributeValues(AttributeValueTargetStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return accountAttribute;
    }

    public static AccountAttributeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AccountAttributeStaxUnmarshaller();
        }
        return instance;
    }
}

