/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CloudwatchLogsExportConfiguration;
import com.amazonaws.services.rds.model.ModifyDBClusterRequest;
import com.amazonaws.services.rds.model.ScalingConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBClusterRequestMarshaller
implements Marshaller<Request<ModifyDBClusterRequest>, ModifyDBClusterRequest> {
    public Request<ModifyDBClusterRequest> marshall(ModifyDBClusterRequest modifyDBClusterRequest) {
        ScalingConfiguration scalingConfiguration;
        CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
        if (modifyDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBClusterRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)modifyDBClusterRequest.getDBClusterIdentifier()));
        }
        if (modifyDBClusterRequest.getNewDBClusterIdentifier() != null) {
            request.addParameter("NewDBClusterIdentifier", StringUtils.fromString((String)modifyDBClusterRequest.getNewDBClusterIdentifier()));
        }
        if (modifyDBClusterRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getApplyImmediately()));
        }
        if (modifyDBClusterRequest.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)modifyDBClusterRequest.getBackupRetentionPeriod()));
        }
        if (modifyDBClusterRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)modifyDBClusterRequest.getDBClusterParameterGroupName()));
        }
        if (!modifyDBClusterRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)modifyDBClusterRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)modifyDBClusterRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (modifyDBClusterRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)modifyDBClusterRequest.getPort()));
        }
        if (modifyDBClusterRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)modifyDBClusterRequest.getMasterUserPassword()));
        }
        if (modifyDBClusterRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)modifyDBClusterRequest.getOptionGroupName()));
        }
        if (modifyDBClusterRequest.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)modifyDBClusterRequest.getPreferredBackupWindow()));
        }
        if (modifyDBClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyDBClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (modifyDBClusterRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (modifyDBClusterRequest.getBacktrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringUtils.fromLong((Long)modifyDBClusterRequest.getBacktrackWindow()));
        }
        if ((cloudwatchLogsExportConfiguration = modifyDBClusterRequest.getCloudwatchLogsExportConfiguration()) != null) {
            if (!cloudwatchLogsExportConfiguration.getEnableLogTypes().isEmpty() || !((SdkInternalList)cloudwatchLogsExportConfiguration.getEnableLogTypes()).isAutoConstruct()) {
                SdkInternalList enableLogTypesList = (SdkInternalList)cloudwatchLogsExportConfiguration.getEnableLogTypes();
                int enableLogTypesListIndex = 1;
                for (String enableLogTypesListValue : enableLogTypesList) {
                    if (enableLogTypesListValue != null) {
                        request.addParameter("CloudwatchLogsExportConfiguration.EnableLogTypes.member." + enableLogTypesListIndex, StringUtils.fromString((String)enableLogTypesListValue));
                    }
                    ++enableLogTypesListIndex;
                }
            }
            if (!cloudwatchLogsExportConfiguration.getDisableLogTypes().isEmpty() || !((SdkInternalList)cloudwatchLogsExportConfiguration.getDisableLogTypes()).isAutoConstruct()) {
                SdkInternalList disableLogTypesList = (SdkInternalList)cloudwatchLogsExportConfiguration.getDisableLogTypes();
                int disableLogTypesListIndex = 1;
                for (String disableLogTypesListValue : disableLogTypesList) {
                    if (disableLogTypesListValue != null) {
                        request.addParameter("CloudwatchLogsExportConfiguration.DisableLogTypes.member." + disableLogTypesListIndex, StringUtils.fromString((String)disableLogTypesListValue));
                    }
                    ++disableLogTypesListIndex;
                }
            }
        }
        if (modifyDBClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyDBClusterRequest.getEngineVersion()));
        }
        if (modifyDBClusterRequest.getAllowMajorVersionUpgrade() != null) {
            request.addParameter("AllowMajorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getAllowMajorVersionUpgrade()));
        }
        if (modifyDBClusterRequest.getDBInstanceParameterGroupName() != null) {
            request.addParameter("DBInstanceParameterGroupName", StringUtils.fromString((String)modifyDBClusterRequest.getDBInstanceParameterGroupName()));
        }
        if (modifyDBClusterRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)modifyDBClusterRequest.getDomain()));
        }
        if (modifyDBClusterRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)modifyDBClusterRequest.getDomainIAMRoleName()));
        }
        if ((scalingConfiguration = modifyDBClusterRequest.getScalingConfiguration()) != null) {
            if (scalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ScalingConfiguration.MinCapacity", StringUtils.fromInteger((Integer)scalingConfiguration.getMinCapacity()));
            }
            if (scalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ScalingConfiguration.MaxCapacity", StringUtils.fromInteger((Integer)scalingConfiguration.getMaxCapacity()));
            }
            if (scalingConfiguration.getAutoPause() != null) {
                request.addParameter("ScalingConfiguration.AutoPause", StringUtils.fromBoolean((Boolean)scalingConfiguration.getAutoPause()));
            }
            if (scalingConfiguration.getSecondsUntilAutoPause() != null) {
                request.addParameter("ScalingConfiguration.SecondsUntilAutoPause", StringUtils.fromInteger((Integer)scalingConfiguration.getSecondsUntilAutoPause()));
            }
            if (scalingConfiguration.getTimeoutAction() != null) {
                request.addParameter("ScalingConfiguration.TimeoutAction", StringUtils.fromString((String)scalingConfiguration.getTimeoutAction()));
            }
            if (scalingConfiguration.getSecondsBeforeTimeout() != null) {
                request.addParameter("ScalingConfiguration.SecondsBeforeTimeout", StringUtils.fromInteger((Integer)scalingConfiguration.getSecondsBeforeTimeout()));
            }
        }
        if (modifyDBClusterRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getDeletionProtection()));
        }
        if (modifyDBClusterRequest.getEnableHttpEndpoint() != null) {
            request.addParameter("EnableHttpEndpoint", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getEnableHttpEndpoint()));
        }
        if (modifyDBClusterRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getCopyTagsToSnapshot()));
        }
        if (modifyDBClusterRequest.getEnableGlobalWriteForwarding() != null) {
            request.addParameter("EnableGlobalWriteForwarding", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getEnableGlobalWriteForwarding()));
        }
        if (modifyDBClusterRequest.getDBClusterInstanceClass() != null) {
            request.addParameter("DBClusterInstanceClass", StringUtils.fromString((String)modifyDBClusterRequest.getDBClusterInstanceClass()));
        }
        if (modifyDBClusterRequest.getAllocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringUtils.fromInteger((Integer)modifyDBClusterRequest.getAllocatedStorage()));
        }
        if (modifyDBClusterRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)modifyDBClusterRequest.getStorageType()));
        }
        if (modifyDBClusterRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)modifyDBClusterRequest.getIops()));
        }
        if (modifyDBClusterRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getAutoMinorVersionUpgrade()));
        }
        if (modifyDBClusterRequest.getMonitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger((Integer)modifyDBClusterRequest.getMonitoringInterval()));
        }
        if (modifyDBClusterRequest.getMonitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString((String)modifyDBClusterRequest.getMonitoringRoleArn()));
        }
        if (modifyDBClusterRequest.getEnablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.getEnablePerformanceInsights()));
        }
        if (modifyDBClusterRequest.getPerformanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringUtils.fromString((String)modifyDBClusterRequest.getPerformanceInsightsKMSKeyId()));
        }
        if (modifyDBClusterRequest.getPerformanceInsightsRetentionPeriod() != null) {
            request.addParameter("PerformanceInsightsRetentionPeriod", StringUtils.fromInteger((Integer)modifyDBClusterRequest.getPerformanceInsightsRetentionPeriod()));
        }
        return request;
    }
}

