/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateCustomDBEngineVersionRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateCustomDBEngineVersionRequestMarshaller
implements Marshaller<Request<CreateCustomDBEngineVersionRequest>, CreateCustomDBEngineVersionRequest> {
    public Request<CreateCustomDBEngineVersionRequest> marshall(CreateCustomDBEngineVersionRequest createCustomDBEngineVersionRequest) {
        if (createCustomDBEngineVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCustomDBEngineVersionRequest, "AmazonRDS");
        request.addParameter("Action", "CreateCustomDBEngineVersion");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCustomDBEngineVersionRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createCustomDBEngineVersionRequest.getEngine()));
        }
        if (createCustomDBEngineVersionRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createCustomDBEngineVersionRequest.getEngineVersion()));
        }
        if (createCustomDBEngineVersionRequest.getDatabaseInstallationFilesS3BucketName() != null) {
            request.addParameter("DatabaseInstallationFilesS3BucketName", StringUtils.fromString((String)createCustomDBEngineVersionRequest.getDatabaseInstallationFilesS3BucketName()));
        }
        if (createCustomDBEngineVersionRequest.getDatabaseInstallationFilesS3Prefix() != null) {
            request.addParameter("DatabaseInstallationFilesS3Prefix", StringUtils.fromString((String)createCustomDBEngineVersionRequest.getDatabaseInstallationFilesS3Prefix()));
        }
        if (createCustomDBEngineVersionRequest.getKMSKeyId() != null) {
            request.addParameter("KMSKeyId", StringUtils.fromString((String)createCustomDBEngineVersionRequest.getKMSKeyId()));
        }
        if (createCustomDBEngineVersionRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createCustomDBEngineVersionRequest.getDescription()));
        }
        if (createCustomDBEngineVersionRequest.getManifest() != null) {
            request.addParameter("Manifest", StringUtils.fromString((String)createCustomDBEngineVersionRequest.getManifest()));
        }
        if (!createCustomDBEngineVersionRequest.getTags().isEmpty() || !((SdkInternalList)createCustomDBEngineVersionRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createCustomDBEngineVersionRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

