/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.rds.model.DeleteDBClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteDBClusterRequestMarshaller
implements Marshaller<Request<DeleteDBClusterRequest>, DeleteDBClusterRequest> {
    public Request<DeleteDBClusterRequest> marshall(DeleteDBClusterRequest deleteDBClusterRequest) {
        if (deleteDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteDBClusterRequest, "AmazonRDS");
        request.addParameter("Action", "DeleteDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)deleteDBClusterRequest.getDBClusterIdentifier()));
        }
        if (deleteDBClusterRequest.getSkipFinalSnapshot() != null) {
            request.addParameter("SkipFinalSnapshot", StringUtils.fromBoolean((Boolean)deleteDBClusterRequest.getSkipFinalSnapshot()));
        }
        if (deleteDBClusterRequest.getFinalDBSnapshotIdentifier() != null) {
            request.addParameter("FinalDBSnapshotIdentifier", StringUtils.fromString((String)deleteDBClusterRequest.getFinalDBSnapshotIdentifier()));
        }
        return request;
    }
}

