/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.quicksight.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * FilterMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class FilterMarshaller {

    private static final MarshallingInfo<StructuredPojo> CATEGORYFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CategoryFilter").build();
    private static final MarshallingInfo<StructuredPojo> NUMERICRANGEFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumericRangeFilter").build();
    private static final MarshallingInfo<StructuredPojo> NUMERICEQUALITYFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumericEqualityFilter").build();
    private static final MarshallingInfo<StructuredPojo> TIMEEQUALITYFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeEqualityFilter").build();
    private static final MarshallingInfo<StructuredPojo> TIMERANGEFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeRangeFilter").build();
    private static final MarshallingInfo<StructuredPojo> RELATIVEDATESFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelativeDatesFilter").build();
    private static final MarshallingInfo<StructuredPojo> TOPBOTTOMFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopBottomFilter").build();
    private static final MarshallingInfo<StructuredPojo> NESTEDFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NestedFilter").build();

    private static final FilterMarshaller instance = new FilterMarshaller();

    public static FilterMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(Filter filter, ProtocolMarshaller protocolMarshaller) {

        if (filter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(filter.getCategoryFilter(), CATEGORYFILTER_BINDING);
            protocolMarshaller.marshall(filter.getNumericRangeFilter(), NUMERICRANGEFILTER_BINDING);
            protocolMarshaller.marshall(filter.getNumericEqualityFilter(), NUMERICEQUALITYFILTER_BINDING);
            protocolMarshaller.marshall(filter.getTimeEqualityFilter(), TIMEEQUALITYFILTER_BINDING);
            protocolMarshaller.marshall(filter.getTimeRangeFilter(), TIMERANGEFILTER_BINDING);
            protocolMarshaller.marshall(filter.getRelativeDatesFilter(), RELATIVEDATESFILTER_BINDING);
            protocolMarshaller.marshall(filter.getTopBottomFilter(), TOPBOTTOMFILTER_BINDING);
            protocolMarshaller.marshall(filter.getNestedFilter(), NESTEDFILTER_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
