/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.BodySectionConfiguration;
import com.amazonaws.services.quicksight.model.HeaderFooterSectionConfiguration;
import com.amazonaws.services.quicksight.model.SectionBasedLayoutCanvasSizeOptions;
import com.amazonaws.services.quicksight.model.transform.SectionBasedLayoutConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SectionBasedLayoutConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<HeaderFooterSectionConfiguration> headerSections;
    private List<BodySectionConfiguration> bodySections;
    private List<HeaderFooterSectionConfiguration> footerSections;
    private SectionBasedLayoutCanvasSizeOptions canvasSizeOptions;

    public List<HeaderFooterSectionConfiguration> getHeaderSections() {
        return this.headerSections;
    }

    public void setHeaderSections(Collection<HeaderFooterSectionConfiguration> headerSections) {
        if (headerSections == null) {
            this.headerSections = null;
            return;
        }
        this.headerSections = new ArrayList<HeaderFooterSectionConfiguration>(headerSections);
    }

    public SectionBasedLayoutConfiguration withHeaderSections(HeaderFooterSectionConfiguration ... headerSections) {
        if (this.headerSections == null) {
            this.setHeaderSections(new ArrayList<HeaderFooterSectionConfiguration>(headerSections.length));
        }
        for (HeaderFooterSectionConfiguration ele : headerSections) {
            this.headerSections.add(ele);
        }
        return this;
    }

    public SectionBasedLayoutConfiguration withHeaderSections(Collection<HeaderFooterSectionConfiguration> headerSections) {
        this.setHeaderSections(headerSections);
        return this;
    }

    public List<BodySectionConfiguration> getBodySections() {
        return this.bodySections;
    }

    public void setBodySections(Collection<BodySectionConfiguration> bodySections) {
        if (bodySections == null) {
            this.bodySections = null;
            return;
        }
        this.bodySections = new ArrayList<BodySectionConfiguration>(bodySections);
    }

    public SectionBasedLayoutConfiguration withBodySections(BodySectionConfiguration ... bodySections) {
        if (this.bodySections == null) {
            this.setBodySections(new ArrayList<BodySectionConfiguration>(bodySections.length));
        }
        for (BodySectionConfiguration ele : bodySections) {
            this.bodySections.add(ele);
        }
        return this;
    }

    public SectionBasedLayoutConfiguration withBodySections(Collection<BodySectionConfiguration> bodySections) {
        this.setBodySections(bodySections);
        return this;
    }

    public List<HeaderFooterSectionConfiguration> getFooterSections() {
        return this.footerSections;
    }

    public void setFooterSections(Collection<HeaderFooterSectionConfiguration> footerSections) {
        if (footerSections == null) {
            this.footerSections = null;
            return;
        }
        this.footerSections = new ArrayList<HeaderFooterSectionConfiguration>(footerSections);
    }

    public SectionBasedLayoutConfiguration withFooterSections(HeaderFooterSectionConfiguration ... footerSections) {
        if (this.footerSections == null) {
            this.setFooterSections(new ArrayList<HeaderFooterSectionConfiguration>(footerSections.length));
        }
        for (HeaderFooterSectionConfiguration ele : footerSections) {
            this.footerSections.add(ele);
        }
        return this;
    }

    public SectionBasedLayoutConfiguration withFooterSections(Collection<HeaderFooterSectionConfiguration> footerSections) {
        this.setFooterSections(footerSections);
        return this;
    }

    public void setCanvasSizeOptions(SectionBasedLayoutCanvasSizeOptions canvasSizeOptions) {
        this.canvasSizeOptions = canvasSizeOptions;
    }

    public SectionBasedLayoutCanvasSizeOptions getCanvasSizeOptions() {
        return this.canvasSizeOptions;
    }

    public SectionBasedLayoutConfiguration withCanvasSizeOptions(SectionBasedLayoutCanvasSizeOptions canvasSizeOptions) {
        this.setCanvasSizeOptions(canvasSizeOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHeaderSections() != null) {
            sb.append("HeaderSections: ").append(this.getHeaderSections()).append(",");
        }
        if (this.getBodySections() != null) {
            sb.append("BodySections: ").append(this.getBodySections()).append(",");
        }
        if (this.getFooterSections() != null) {
            sb.append("FooterSections: ").append(this.getFooterSections()).append(",");
        }
        if (this.getCanvasSizeOptions() != null) {
            sb.append("CanvasSizeOptions: ").append(this.getCanvasSizeOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionBasedLayoutConfiguration)) {
            return false;
        }
        SectionBasedLayoutConfiguration other = (SectionBasedLayoutConfiguration)obj;
        if (other.getHeaderSections() == null ^ this.getHeaderSections() == null) {
            return false;
        }
        if (other.getHeaderSections() != null && !other.getHeaderSections().equals(this.getHeaderSections())) {
            return false;
        }
        if (other.getBodySections() == null ^ this.getBodySections() == null) {
            return false;
        }
        if (other.getBodySections() != null && !other.getBodySections().equals(this.getBodySections())) {
            return false;
        }
        if (other.getFooterSections() == null ^ this.getFooterSections() == null) {
            return false;
        }
        if (other.getFooterSections() != null && !other.getFooterSections().equals(this.getFooterSections())) {
            return false;
        }
        if (other.getCanvasSizeOptions() == null ^ this.getCanvasSizeOptions() == null) {
            return false;
        }
        return other.getCanvasSizeOptions() == null || other.getCanvasSizeOptions().equals(this.getCanvasSizeOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHeaderSections() == null ? 0 : this.getHeaderSections().hashCode());
        hashCode = 31 * hashCode + (this.getBodySections() == null ? 0 : this.getBodySections().hashCode());
        hashCode = 31 * hashCode + (this.getFooterSections() == null ? 0 : this.getFooterSections().hashCode());
        hashCode = 31 * hashCode + (this.getCanvasSizeOptions() == null ? 0 : this.getCanvasSizeOptions().hashCode());
        return hashCode;
    }

    public SectionBasedLayoutConfiguration clone() {
        try {
            return (SectionBasedLayoutConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SectionBasedLayoutConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

