/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.FieldSortOptions;
import com.amazonaws.services.quicksight.model.ItemsLimitConfiguration;
import com.amazonaws.services.quicksight.model.transform.PieChartSortConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PieChartSortConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FieldSortOptions> categorySort;
    private ItemsLimitConfiguration categoryItemsLimit;
    private List<FieldSortOptions> smallMultiplesSort;
    private ItemsLimitConfiguration smallMultiplesLimitConfiguration;

    public List<FieldSortOptions> getCategorySort() {
        return this.categorySort;
    }

    public void setCategorySort(Collection<FieldSortOptions> categorySort) {
        if (categorySort == null) {
            this.categorySort = null;
            return;
        }
        this.categorySort = new ArrayList<FieldSortOptions>(categorySort);
    }

    public PieChartSortConfiguration withCategorySort(FieldSortOptions ... categorySort) {
        if (this.categorySort == null) {
            this.setCategorySort(new ArrayList<FieldSortOptions>(categorySort.length));
        }
        for (FieldSortOptions ele : categorySort) {
            this.categorySort.add(ele);
        }
        return this;
    }

    public PieChartSortConfiguration withCategorySort(Collection<FieldSortOptions> categorySort) {
        this.setCategorySort(categorySort);
        return this;
    }

    public void setCategoryItemsLimit(ItemsLimitConfiguration categoryItemsLimit) {
        this.categoryItemsLimit = categoryItemsLimit;
    }

    public ItemsLimitConfiguration getCategoryItemsLimit() {
        return this.categoryItemsLimit;
    }

    public PieChartSortConfiguration withCategoryItemsLimit(ItemsLimitConfiguration categoryItemsLimit) {
        this.setCategoryItemsLimit(categoryItemsLimit);
        return this;
    }

    public List<FieldSortOptions> getSmallMultiplesSort() {
        return this.smallMultiplesSort;
    }

    public void setSmallMultiplesSort(Collection<FieldSortOptions> smallMultiplesSort) {
        if (smallMultiplesSort == null) {
            this.smallMultiplesSort = null;
            return;
        }
        this.smallMultiplesSort = new ArrayList<FieldSortOptions>(smallMultiplesSort);
    }

    public PieChartSortConfiguration withSmallMultiplesSort(FieldSortOptions ... smallMultiplesSort) {
        if (this.smallMultiplesSort == null) {
            this.setSmallMultiplesSort(new ArrayList<FieldSortOptions>(smallMultiplesSort.length));
        }
        for (FieldSortOptions ele : smallMultiplesSort) {
            this.smallMultiplesSort.add(ele);
        }
        return this;
    }

    public PieChartSortConfiguration withSmallMultiplesSort(Collection<FieldSortOptions> smallMultiplesSort) {
        this.setSmallMultiplesSort(smallMultiplesSort);
        return this;
    }

    public void setSmallMultiplesLimitConfiguration(ItemsLimitConfiguration smallMultiplesLimitConfiguration) {
        this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
    }

    public ItemsLimitConfiguration getSmallMultiplesLimitConfiguration() {
        return this.smallMultiplesLimitConfiguration;
    }

    public PieChartSortConfiguration withSmallMultiplesLimitConfiguration(ItemsLimitConfiguration smallMultiplesLimitConfiguration) {
        this.setSmallMultiplesLimitConfiguration(smallMultiplesLimitConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategorySort() != null) {
            sb.append("CategorySort: ").append(this.getCategorySort()).append(",");
        }
        if (this.getCategoryItemsLimit() != null) {
            sb.append("CategoryItemsLimit: ").append(this.getCategoryItemsLimit()).append(",");
        }
        if (this.getSmallMultiplesSort() != null) {
            sb.append("SmallMultiplesSort: ").append(this.getSmallMultiplesSort()).append(",");
        }
        if (this.getSmallMultiplesLimitConfiguration() != null) {
            sb.append("SmallMultiplesLimitConfiguration: ").append(this.getSmallMultiplesLimitConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PieChartSortConfiguration)) {
            return false;
        }
        PieChartSortConfiguration other = (PieChartSortConfiguration)obj;
        if (other.getCategorySort() == null ^ this.getCategorySort() == null) {
            return false;
        }
        if (other.getCategorySort() != null && !other.getCategorySort().equals(this.getCategorySort())) {
            return false;
        }
        if (other.getCategoryItemsLimit() == null ^ this.getCategoryItemsLimit() == null) {
            return false;
        }
        if (other.getCategoryItemsLimit() != null && !other.getCategoryItemsLimit().equals(this.getCategoryItemsLimit())) {
            return false;
        }
        if (other.getSmallMultiplesSort() == null ^ this.getSmallMultiplesSort() == null) {
            return false;
        }
        if (other.getSmallMultiplesSort() != null && !other.getSmallMultiplesSort().equals(this.getSmallMultiplesSort())) {
            return false;
        }
        if (other.getSmallMultiplesLimitConfiguration() == null ^ this.getSmallMultiplesLimitConfiguration() == null) {
            return false;
        }
        return other.getSmallMultiplesLimitConfiguration() == null || other.getSmallMultiplesLimitConfiguration().equals(this.getSmallMultiplesLimitConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategorySort() == null ? 0 : this.getCategorySort().hashCode());
        hashCode = 31 * hashCode + (this.getCategoryItemsLimit() == null ? 0 : this.getCategoryItemsLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSmallMultiplesSort() == null ? 0 : this.getSmallMultiplesSort().hashCode());
        hashCode = 31 * hashCode + (this.getSmallMultiplesLimitConfiguration() == null ? 0 : this.getSmallMultiplesLimitConfiguration().hashCode());
        return hashCode;
    }

    public PieChartSortConfiguration clone() {
        try {
            return (PieChartSortConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PieChartSortConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

