/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ForecastComputation;

@SdkInternalApi
public class ForecastComputationMarshaller {
    private static final MarshallingInfo<String> COMPUTATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputationId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> TIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Time").build();
    private static final MarshallingInfo<StructuredPojo> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Integer> PERIODSFORWARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PeriodsForward").build();
    private static final MarshallingInfo<Integer> PERIODSBACKWARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PeriodsBackward").build();
    private static final MarshallingInfo<Double> UPPERBOUNDARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpperBoundary").build();
    private static final MarshallingInfo<Double> LOWERBOUNDARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LowerBoundary").build();
    private static final MarshallingInfo<Integer> PREDICTIONINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredictionInterval").build();
    private static final MarshallingInfo<String> SEASONALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Seasonality").build();
    private static final MarshallingInfo<Integer> CUSTOMSEASONALITYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomSeasonalityValue").build();
    private static final ForecastComputationMarshaller instance = new ForecastComputationMarshaller();

    public static ForecastComputationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ForecastComputation forecastComputation, ProtocolMarshaller protocolMarshaller) {
        if (forecastComputation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)forecastComputation.getComputationId(), COMPUTATIONID_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getTime(), TIME_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getPeriodsForward(), PERIODSFORWARD_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getPeriodsBackward(), PERIODSBACKWARD_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getUpperBoundary(), UPPERBOUNDARY_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getLowerBoundary(), LOWERBOUNDARY_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getPredictionInterval(), PREDICTIONINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getSeasonality(), SEASONALITY_BINDING);
            protocolMarshaller.marshall((Object)forecastComputation.getCustomSeasonalityValue(), CUSTOMSEASONALITYVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

