/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.Typography;
import java.util.List;

@SdkInternalApi
public class TypographyMarshaller {
    private static final MarshallingInfo<List> FONTFAMILIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FontFamilies").build();
    private static final TypographyMarshaller instance = new TypographyMarshaller();

    public static TypographyMarshaller getInstance() {
        return instance;
    }

    public void marshall(Typography typography, ProtocolMarshaller protocolMarshaller) {
        if (typography == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(typography.getFontFamilies(), FONTFAMILIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

