/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ColorFillType;
import com.amazonaws.services.quicksight.model.DataColor;
import com.amazonaws.services.quicksight.model.transform.ColorScaleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColorScale
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DataColor> colors;
    private String colorFillType;
    private DataColor nullValueColor;

    public List<DataColor> getColors() {
        return this.colors;
    }

    public void setColors(Collection<DataColor> colors) {
        if (colors == null) {
            this.colors = null;
            return;
        }
        this.colors = new ArrayList<DataColor>(colors);
    }

    public ColorScale withColors(DataColor ... colors) {
        if (this.colors == null) {
            this.setColors(new ArrayList<DataColor>(colors.length));
        }
        for (DataColor ele : colors) {
            this.colors.add(ele);
        }
        return this;
    }

    public ColorScale withColors(Collection<DataColor> colors) {
        this.setColors(colors);
        return this;
    }

    public void setColorFillType(String colorFillType) {
        this.colorFillType = colorFillType;
    }

    public String getColorFillType() {
        return this.colorFillType;
    }

    public ColorScale withColorFillType(String colorFillType) {
        this.setColorFillType(colorFillType);
        return this;
    }

    public ColorScale withColorFillType(ColorFillType colorFillType) {
        this.colorFillType = colorFillType.toString();
        return this;
    }

    public void setNullValueColor(DataColor nullValueColor) {
        this.nullValueColor = nullValueColor;
    }

    public DataColor getNullValueColor() {
        return this.nullValueColor;
    }

    public ColorScale withNullValueColor(DataColor nullValueColor) {
        this.setNullValueColor(nullValueColor);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColors() != null) {
            sb.append("Colors: ").append(this.getColors()).append(",");
        }
        if (this.getColorFillType() != null) {
            sb.append("ColorFillType: ").append(this.getColorFillType()).append(",");
        }
        if (this.getNullValueColor() != null) {
            sb.append("NullValueColor: ").append(this.getNullValueColor());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorScale)) {
            return false;
        }
        ColorScale other = (ColorScale)obj;
        if (other.getColors() == null ^ this.getColors() == null) {
            return false;
        }
        if (other.getColors() != null && !other.getColors().equals(this.getColors())) {
            return false;
        }
        if (other.getColorFillType() == null ^ this.getColorFillType() == null) {
            return false;
        }
        if (other.getColorFillType() != null && !other.getColorFillType().equals(this.getColorFillType())) {
            return false;
        }
        if (other.getNullValueColor() == null ^ this.getNullValueColor() == null) {
            return false;
        }
        return other.getNullValueColor() == null || other.getNullValueColor().equals(this.getNullValueColor());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColors() == null ? 0 : this.getColors().hashCode());
        hashCode = 31 * hashCode + (this.getColorFillType() == null ? 0 : this.getColorFillType().hashCode());
        hashCode = 31 * hashCode + (this.getNullValueColor() == null ? 0 : this.getNullValueColor().hashCode());
        return hashCode;
    }

    public ColorScale clone() {
        try {
            return (ColorScale)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ColorScaleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

