/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DynamicDefaultValue;
import com.amazonaws.services.quicksight.model.RollingDateConfiguration;
import com.amazonaws.services.quicksight.model.transform.DateTimeDefaultValuesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DateTimeDefaultValues
implements Serializable,
Cloneable,
StructuredPojo {
    private DynamicDefaultValue dynamicValue;
    private List<Date> staticValues;
    private RollingDateConfiguration rollingDate;

    public void setDynamicValue(DynamicDefaultValue dynamicValue) {
        this.dynamicValue = dynamicValue;
    }

    public DynamicDefaultValue getDynamicValue() {
        return this.dynamicValue;
    }

    public DateTimeDefaultValues withDynamicValue(DynamicDefaultValue dynamicValue) {
        this.setDynamicValue(dynamicValue);
        return this;
    }

    public List<Date> getStaticValues() {
        return this.staticValues;
    }

    public void setStaticValues(Collection<Date> staticValues) {
        if (staticValues == null) {
            this.staticValues = null;
            return;
        }
        this.staticValues = new ArrayList<Date>(staticValues);
    }

    public DateTimeDefaultValues withStaticValues(Date ... staticValues) {
        if (this.staticValues == null) {
            this.setStaticValues(new ArrayList<Date>(staticValues.length));
        }
        for (Date ele : staticValues) {
            this.staticValues.add(ele);
        }
        return this;
    }

    public DateTimeDefaultValues withStaticValues(Collection<Date> staticValues) {
        this.setStaticValues(staticValues);
        return this;
    }

    public void setRollingDate(RollingDateConfiguration rollingDate) {
        this.rollingDate = rollingDate;
    }

    public RollingDateConfiguration getRollingDate() {
        return this.rollingDate;
    }

    public DateTimeDefaultValues withRollingDate(RollingDateConfiguration rollingDate) {
        this.setRollingDate(rollingDate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDynamicValue() != null) {
            sb.append("DynamicValue: ").append(this.getDynamicValue()).append(",");
        }
        if (this.getStaticValues() != null) {
            sb.append("StaticValues: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getRollingDate() != null) {
            sb.append("RollingDate: ").append(this.getRollingDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeDefaultValues)) {
            return false;
        }
        DateTimeDefaultValues other = (DateTimeDefaultValues)obj;
        if (other.getDynamicValue() == null ^ this.getDynamicValue() == null) {
            return false;
        }
        if (other.getDynamicValue() != null && !other.getDynamicValue().equals(this.getDynamicValue())) {
            return false;
        }
        if (other.getStaticValues() == null ^ this.getStaticValues() == null) {
            return false;
        }
        if (other.getStaticValues() != null && !other.getStaticValues().equals(this.getStaticValues())) {
            return false;
        }
        if (other.getRollingDate() == null ^ this.getRollingDate() == null) {
            return false;
        }
        return other.getRollingDate() == null || other.getRollingDate().equals(this.getRollingDate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDynamicValue() == null ? 0 : this.getDynamicValue().hashCode());
        hashCode = 31 * hashCode + (this.getStaticValues() == null ? 0 : this.getStaticValues().hashCode());
        hashCode = 31 * hashCode + (this.getRollingDate() == null ? 0 : this.getRollingDate().hashCode());
        return hashCode;
    }

    public DateTimeDefaultValues clone() {
        try {
            return (DateTimeDefaultValues)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DateTimeDefaultValuesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

