/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.LayoutConfiguration;

@SdkInternalApi
public class LayoutConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> GRIDLAYOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GridLayout").build();
    private static final MarshallingInfo<StructuredPojo> FREEFORMLAYOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FreeFormLayout").build();
    private static final MarshallingInfo<StructuredPojo> SECTIONBASEDLAYOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SectionBasedLayout").build();
    private static final LayoutConfigurationMarshaller instance = new LayoutConfigurationMarshaller();

    public static LayoutConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(LayoutConfiguration layoutConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (layoutConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)layoutConfiguration.getGridLayout(), GRIDLAYOUT_BINDING);
            protocolMarshaller.marshall((Object)layoutConfiguration.getFreeFormLayout(), FREEFORMLAYOUT_BINDING);
            protocolMarshaller.marshall((Object)layoutConfiguration.getSectionBasedLayout(), SECTIONBASEDLAYOUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

