/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Conditional formatting options of a <code>FilledMapVisual</code>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/FilledMapConditionalFormattingOption"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FilledMapConditionalFormattingOption implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The conditional formatting that determines the shape of the filled map.
     * </p>
     */
    private FilledMapShapeConditionalFormatting shape;

    /**
     * <p>
     * The conditional formatting that determines the shape of the filled map.
     * </p>
     * 
     * @param shape
     *        The conditional formatting that determines the shape of the filled map.
     */

    public void setShape(FilledMapShapeConditionalFormatting shape) {
        this.shape = shape;
    }

    /**
     * <p>
     * The conditional formatting that determines the shape of the filled map.
     * </p>
     * 
     * @return The conditional formatting that determines the shape of the filled map.
     */

    public FilledMapShapeConditionalFormatting getShape() {
        return this.shape;
    }

    /**
     * <p>
     * The conditional formatting that determines the shape of the filled map.
     * </p>
     * 
     * @param shape
     *        The conditional formatting that determines the shape of the filled map.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FilledMapConditionalFormattingOption withShape(FilledMapShapeConditionalFormatting shape) {
        setShape(shape);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getShape() != null)
            sb.append("Shape: ").append(getShape());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FilledMapConditionalFormattingOption == false)
            return false;
        FilledMapConditionalFormattingOption other = (FilledMapConditionalFormattingOption) obj;
        if (other.getShape() == null ^ this.getShape() == null)
            return false;
        if (other.getShape() != null && other.getShape().equals(this.getShape()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getShape() == null) ? 0 : getShape().hashCode());
        return hashCode;
    }

    @Override
    public FilledMapConditionalFormattingOption clone() {
        try {
            return (FilledMapConditionalFormattingOption) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.FilledMapConditionalFormattingOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
