/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AxisDisplayOptions;
import com.amazonaws.services.quicksight.model.BarChartFieldWells;
import com.amazonaws.services.quicksight.model.BarChartOrientation;
import com.amazonaws.services.quicksight.model.BarChartSortConfiguration;
import com.amazonaws.services.quicksight.model.BarsArrangement;
import com.amazonaws.services.quicksight.model.ChartAxisLabelOptions;
import com.amazonaws.services.quicksight.model.ContributionAnalysisDefault;
import com.amazonaws.services.quicksight.model.DataLabelOptions;
import com.amazonaws.services.quicksight.model.LegendOptions;
import com.amazonaws.services.quicksight.model.ReferenceLine;
import com.amazonaws.services.quicksight.model.SmallMultiplesOptions;
import com.amazonaws.services.quicksight.model.TooltipOptions;
import com.amazonaws.services.quicksight.model.VisualPalette;
import com.amazonaws.services.quicksight.model.transform.BarChartConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BarChartConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private BarChartFieldWells fieldWells;
    private BarChartSortConfiguration sortConfiguration;
    private String orientation;
    private String barsArrangement;
    private VisualPalette visualPalette;
    private SmallMultiplesOptions smallMultiplesOptions;
    private AxisDisplayOptions categoryAxis;
    private ChartAxisLabelOptions categoryLabelOptions;
    private AxisDisplayOptions valueAxis;
    private ChartAxisLabelOptions valueLabelOptions;
    private ChartAxisLabelOptions colorLabelOptions;
    private LegendOptions legend;
    private DataLabelOptions dataLabels;
    private TooltipOptions tooltip;
    private List<ReferenceLine> referenceLines;
    private List<ContributionAnalysisDefault> contributionAnalysisDefaults;

    public void setFieldWells(BarChartFieldWells fieldWells) {
        this.fieldWells = fieldWells;
    }

    public BarChartFieldWells getFieldWells() {
        return this.fieldWells;
    }

    public BarChartConfiguration withFieldWells(BarChartFieldWells fieldWells) {
        this.setFieldWells(fieldWells);
        return this;
    }

    public void setSortConfiguration(BarChartSortConfiguration sortConfiguration) {
        this.sortConfiguration = sortConfiguration;
    }

    public BarChartSortConfiguration getSortConfiguration() {
        return this.sortConfiguration;
    }

    public BarChartConfiguration withSortConfiguration(BarChartSortConfiguration sortConfiguration) {
        this.setSortConfiguration(sortConfiguration);
        return this;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public BarChartConfiguration withOrientation(String orientation) {
        this.setOrientation(orientation);
        return this;
    }

    public BarChartConfiguration withOrientation(BarChartOrientation orientation) {
        this.orientation = orientation.toString();
        return this;
    }

    public void setBarsArrangement(String barsArrangement) {
        this.barsArrangement = barsArrangement;
    }

    public String getBarsArrangement() {
        return this.barsArrangement;
    }

    public BarChartConfiguration withBarsArrangement(String barsArrangement) {
        this.setBarsArrangement(barsArrangement);
        return this;
    }

    public BarChartConfiguration withBarsArrangement(BarsArrangement barsArrangement) {
        this.barsArrangement = barsArrangement.toString();
        return this;
    }

    public void setVisualPalette(VisualPalette visualPalette) {
        this.visualPalette = visualPalette;
    }

    public VisualPalette getVisualPalette() {
        return this.visualPalette;
    }

    public BarChartConfiguration withVisualPalette(VisualPalette visualPalette) {
        this.setVisualPalette(visualPalette);
        return this;
    }

    public void setSmallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
        this.smallMultiplesOptions = smallMultiplesOptions;
    }

    public SmallMultiplesOptions getSmallMultiplesOptions() {
        return this.smallMultiplesOptions;
    }

    public BarChartConfiguration withSmallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
        this.setSmallMultiplesOptions(smallMultiplesOptions);
        return this;
    }

    public void setCategoryAxis(AxisDisplayOptions categoryAxis) {
        this.categoryAxis = categoryAxis;
    }

    public AxisDisplayOptions getCategoryAxis() {
        return this.categoryAxis;
    }

    public BarChartConfiguration withCategoryAxis(AxisDisplayOptions categoryAxis) {
        this.setCategoryAxis(categoryAxis);
        return this;
    }

    public void setCategoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
        this.categoryLabelOptions = categoryLabelOptions;
    }

    public ChartAxisLabelOptions getCategoryLabelOptions() {
        return this.categoryLabelOptions;
    }

    public BarChartConfiguration withCategoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
        this.setCategoryLabelOptions(categoryLabelOptions);
        return this;
    }

    public void setValueAxis(AxisDisplayOptions valueAxis) {
        this.valueAxis = valueAxis;
    }

    public AxisDisplayOptions getValueAxis() {
        return this.valueAxis;
    }

    public BarChartConfiguration withValueAxis(AxisDisplayOptions valueAxis) {
        this.setValueAxis(valueAxis);
        return this;
    }

    public void setValueLabelOptions(ChartAxisLabelOptions valueLabelOptions) {
        this.valueLabelOptions = valueLabelOptions;
    }

    public ChartAxisLabelOptions getValueLabelOptions() {
        return this.valueLabelOptions;
    }

    public BarChartConfiguration withValueLabelOptions(ChartAxisLabelOptions valueLabelOptions) {
        this.setValueLabelOptions(valueLabelOptions);
        return this;
    }

    public void setColorLabelOptions(ChartAxisLabelOptions colorLabelOptions) {
        this.colorLabelOptions = colorLabelOptions;
    }

    public ChartAxisLabelOptions getColorLabelOptions() {
        return this.colorLabelOptions;
    }

    public BarChartConfiguration withColorLabelOptions(ChartAxisLabelOptions colorLabelOptions) {
        this.setColorLabelOptions(colorLabelOptions);
        return this;
    }

    public void setLegend(LegendOptions legend) {
        this.legend = legend;
    }

    public LegendOptions getLegend() {
        return this.legend;
    }

    public BarChartConfiguration withLegend(LegendOptions legend) {
        this.setLegend(legend);
        return this;
    }

    public void setDataLabels(DataLabelOptions dataLabels) {
        this.dataLabels = dataLabels;
    }

    public DataLabelOptions getDataLabels() {
        return this.dataLabels;
    }

    public BarChartConfiguration withDataLabels(DataLabelOptions dataLabels) {
        this.setDataLabels(dataLabels);
        return this;
    }

    public void setTooltip(TooltipOptions tooltip) {
        this.tooltip = tooltip;
    }

    public TooltipOptions getTooltip() {
        return this.tooltip;
    }

    public BarChartConfiguration withTooltip(TooltipOptions tooltip) {
        this.setTooltip(tooltip);
        return this;
    }

    public List<ReferenceLine> getReferenceLines() {
        return this.referenceLines;
    }

    public void setReferenceLines(Collection<ReferenceLine> referenceLines) {
        if (referenceLines == null) {
            this.referenceLines = null;
            return;
        }
        this.referenceLines = new ArrayList<ReferenceLine>(referenceLines);
    }

    public BarChartConfiguration withReferenceLines(ReferenceLine ... referenceLines) {
        if (this.referenceLines == null) {
            this.setReferenceLines(new ArrayList<ReferenceLine>(referenceLines.length));
        }
        for (ReferenceLine ele : referenceLines) {
            this.referenceLines.add(ele);
        }
        return this;
    }

    public BarChartConfiguration withReferenceLines(Collection<ReferenceLine> referenceLines) {
        this.setReferenceLines(referenceLines);
        return this;
    }

    public List<ContributionAnalysisDefault> getContributionAnalysisDefaults() {
        return this.contributionAnalysisDefaults;
    }

    public void setContributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
        if (contributionAnalysisDefaults == null) {
            this.contributionAnalysisDefaults = null;
            return;
        }
        this.contributionAnalysisDefaults = new ArrayList<ContributionAnalysisDefault>(contributionAnalysisDefaults);
    }

    public BarChartConfiguration withContributionAnalysisDefaults(ContributionAnalysisDefault ... contributionAnalysisDefaults) {
        if (this.contributionAnalysisDefaults == null) {
            this.setContributionAnalysisDefaults(new ArrayList<ContributionAnalysisDefault>(contributionAnalysisDefaults.length));
        }
        for (ContributionAnalysisDefault ele : contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults.add(ele);
        }
        return this;
    }

    public BarChartConfiguration withContributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
        this.setContributionAnalysisDefaults(contributionAnalysisDefaults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFieldWells() != null) {
            sb.append("FieldWells: ").append(this.getFieldWells()).append(",");
        }
        if (this.getSortConfiguration() != null) {
            sb.append("SortConfiguration: ").append(this.getSortConfiguration()).append(",");
        }
        if (this.getOrientation() != null) {
            sb.append("Orientation: ").append(this.getOrientation()).append(",");
        }
        if (this.getBarsArrangement() != null) {
            sb.append("BarsArrangement: ").append(this.getBarsArrangement()).append(",");
        }
        if (this.getVisualPalette() != null) {
            sb.append("VisualPalette: ").append(this.getVisualPalette()).append(",");
        }
        if (this.getSmallMultiplesOptions() != null) {
            sb.append("SmallMultiplesOptions: ").append(this.getSmallMultiplesOptions()).append(",");
        }
        if (this.getCategoryAxis() != null) {
            sb.append("CategoryAxis: ").append(this.getCategoryAxis()).append(",");
        }
        if (this.getCategoryLabelOptions() != null) {
            sb.append("CategoryLabelOptions: ").append(this.getCategoryLabelOptions()).append(",");
        }
        if (this.getValueAxis() != null) {
            sb.append("ValueAxis: ").append(this.getValueAxis()).append(",");
        }
        if (this.getValueLabelOptions() != null) {
            sb.append("ValueLabelOptions: ").append(this.getValueLabelOptions()).append(",");
        }
        if (this.getColorLabelOptions() != null) {
            sb.append("ColorLabelOptions: ").append(this.getColorLabelOptions()).append(",");
        }
        if (this.getLegend() != null) {
            sb.append("Legend: ").append(this.getLegend()).append(",");
        }
        if (this.getDataLabels() != null) {
            sb.append("DataLabels: ").append(this.getDataLabels()).append(",");
        }
        if (this.getTooltip() != null) {
            sb.append("Tooltip: ").append(this.getTooltip()).append(",");
        }
        if (this.getReferenceLines() != null) {
            sb.append("ReferenceLines: ").append(this.getReferenceLines()).append(",");
        }
        if (this.getContributionAnalysisDefaults() != null) {
            sb.append("ContributionAnalysisDefaults: ").append(this.getContributionAnalysisDefaults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BarChartConfiguration)) {
            return false;
        }
        BarChartConfiguration other = (BarChartConfiguration)obj;
        if (other.getFieldWells() == null ^ this.getFieldWells() == null) {
            return false;
        }
        if (other.getFieldWells() != null && !other.getFieldWells().equals(this.getFieldWells())) {
            return false;
        }
        if (other.getSortConfiguration() == null ^ this.getSortConfiguration() == null) {
            return false;
        }
        if (other.getSortConfiguration() != null && !other.getSortConfiguration().equals(this.getSortConfiguration())) {
            return false;
        }
        if (other.getOrientation() == null ^ this.getOrientation() == null) {
            return false;
        }
        if (other.getOrientation() != null && !other.getOrientation().equals(this.getOrientation())) {
            return false;
        }
        if (other.getBarsArrangement() == null ^ this.getBarsArrangement() == null) {
            return false;
        }
        if (other.getBarsArrangement() != null && !other.getBarsArrangement().equals(this.getBarsArrangement())) {
            return false;
        }
        if (other.getVisualPalette() == null ^ this.getVisualPalette() == null) {
            return false;
        }
        if (other.getVisualPalette() != null && !other.getVisualPalette().equals(this.getVisualPalette())) {
            return false;
        }
        if (other.getSmallMultiplesOptions() == null ^ this.getSmallMultiplesOptions() == null) {
            return false;
        }
        if (other.getSmallMultiplesOptions() != null && !other.getSmallMultiplesOptions().equals(this.getSmallMultiplesOptions())) {
            return false;
        }
        if (other.getCategoryAxis() == null ^ this.getCategoryAxis() == null) {
            return false;
        }
        if (other.getCategoryAxis() != null && !other.getCategoryAxis().equals(this.getCategoryAxis())) {
            return false;
        }
        if (other.getCategoryLabelOptions() == null ^ this.getCategoryLabelOptions() == null) {
            return false;
        }
        if (other.getCategoryLabelOptions() != null && !other.getCategoryLabelOptions().equals(this.getCategoryLabelOptions())) {
            return false;
        }
        if (other.getValueAxis() == null ^ this.getValueAxis() == null) {
            return false;
        }
        if (other.getValueAxis() != null && !other.getValueAxis().equals(this.getValueAxis())) {
            return false;
        }
        if (other.getValueLabelOptions() == null ^ this.getValueLabelOptions() == null) {
            return false;
        }
        if (other.getValueLabelOptions() != null && !other.getValueLabelOptions().equals(this.getValueLabelOptions())) {
            return false;
        }
        if (other.getColorLabelOptions() == null ^ this.getColorLabelOptions() == null) {
            return false;
        }
        if (other.getColorLabelOptions() != null && !other.getColorLabelOptions().equals(this.getColorLabelOptions())) {
            return false;
        }
        if (other.getLegend() == null ^ this.getLegend() == null) {
            return false;
        }
        if (other.getLegend() != null && !other.getLegend().equals(this.getLegend())) {
            return false;
        }
        if (other.getDataLabels() == null ^ this.getDataLabels() == null) {
            return false;
        }
        if (other.getDataLabels() != null && !other.getDataLabels().equals(this.getDataLabels())) {
            return false;
        }
        if (other.getTooltip() == null ^ this.getTooltip() == null) {
            return false;
        }
        if (other.getTooltip() != null && !other.getTooltip().equals(this.getTooltip())) {
            return false;
        }
        if (other.getReferenceLines() == null ^ this.getReferenceLines() == null) {
            return false;
        }
        if (other.getReferenceLines() != null && !other.getReferenceLines().equals(this.getReferenceLines())) {
            return false;
        }
        if (other.getContributionAnalysisDefaults() == null ^ this.getContributionAnalysisDefaults() == null) {
            return false;
        }
        return other.getContributionAnalysisDefaults() == null || other.getContributionAnalysisDefaults().equals(this.getContributionAnalysisDefaults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFieldWells() == null ? 0 : this.getFieldWells().hashCode());
        hashCode = 31 * hashCode + (this.getSortConfiguration() == null ? 0 : this.getSortConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getOrientation() == null ? 0 : this.getOrientation().hashCode());
        hashCode = 31 * hashCode + (this.getBarsArrangement() == null ? 0 : this.getBarsArrangement().hashCode());
        hashCode = 31 * hashCode + (this.getVisualPalette() == null ? 0 : this.getVisualPalette().hashCode());
        hashCode = 31 * hashCode + (this.getSmallMultiplesOptions() == null ? 0 : this.getSmallMultiplesOptions().hashCode());
        hashCode = 31 * hashCode + (this.getCategoryAxis() == null ? 0 : this.getCategoryAxis().hashCode());
        hashCode = 31 * hashCode + (this.getCategoryLabelOptions() == null ? 0 : this.getCategoryLabelOptions().hashCode());
        hashCode = 31 * hashCode + (this.getValueAxis() == null ? 0 : this.getValueAxis().hashCode());
        hashCode = 31 * hashCode + (this.getValueLabelOptions() == null ? 0 : this.getValueLabelOptions().hashCode());
        hashCode = 31 * hashCode + (this.getColorLabelOptions() == null ? 0 : this.getColorLabelOptions().hashCode());
        hashCode = 31 * hashCode + (this.getLegend() == null ? 0 : this.getLegend().hashCode());
        hashCode = 31 * hashCode + (this.getDataLabels() == null ? 0 : this.getDataLabels().hashCode());
        hashCode = 31 * hashCode + (this.getTooltip() == null ? 0 : this.getTooltip().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceLines() == null ? 0 : this.getReferenceLines().hashCode());
        hashCode = 31 * hashCode + (this.getContributionAnalysisDefaults() == null ? 0 : this.getContributionAnalysisDefaults().hashCode());
        return hashCode;
    }

    public BarChartConfiguration clone() {
        try {
            return (BarChartConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BarChartConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

