/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AnalysisErrorType;
import com.amazonaws.services.quicksight.model.Entity;
import com.amazonaws.services.quicksight.model.transform.AnalysisErrorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnalysisError
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String message;
    private List<Entity> violatedEntities;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public AnalysisError withType(String type) {
        this.setType(type);
        return this;
    }

    public AnalysisError withType(AnalysisErrorType type) {
        this.type = type.toString();
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public AnalysisError withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public List<Entity> getViolatedEntities() {
        return this.violatedEntities;
    }

    public void setViolatedEntities(Collection<Entity> violatedEntities) {
        if (violatedEntities == null) {
            this.violatedEntities = null;
            return;
        }
        this.violatedEntities = new ArrayList<Entity>(violatedEntities);
    }

    public AnalysisError withViolatedEntities(Entity ... violatedEntities) {
        if (this.violatedEntities == null) {
            this.setViolatedEntities(new ArrayList<Entity>(violatedEntities.length));
        }
        for (Entity ele : violatedEntities) {
            this.violatedEntities.add(ele);
        }
        return this;
    }

    public AnalysisError withViolatedEntities(Collection<Entity> violatedEntities) {
        this.setViolatedEntities(violatedEntities);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getViolatedEntities() != null) {
            sb.append("ViolatedEntities: ").append(this.getViolatedEntities());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisError)) {
            return false;
        }
        AnalysisError other = (AnalysisError)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getViolatedEntities() == null ^ this.getViolatedEntities() == null) {
            return false;
        }
        return other.getViolatedEntities() == null || other.getViolatedEntities().equals(this.getViolatedEntities());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getViolatedEntities() == null ? 0 : this.getViolatedEntities().hashCode());
        return hashCode;
    }

    public AnalysisError clone() {
        try {
            return (AnalysisError)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnalysisErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

