/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.qbusiness.model.DeleteDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDeleteDocumentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationId;
    private String indexId;
    private List<DeleteDocument> documents;
    private String dataSourceSyncId;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public BatchDeleteDocumentRequest withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public BatchDeleteDocumentRequest withIndexId(String indexId) {
        this.setIndexId(indexId);
        return this;
    }

    public List<DeleteDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(Collection<DeleteDocument> documents) {
        if (documents == null) {
            this.documents = null;
            return;
        }
        this.documents = new ArrayList<DeleteDocument>(documents);
    }

    public BatchDeleteDocumentRequest withDocuments(DeleteDocument ... documents) {
        if (this.documents == null) {
            this.setDocuments(new ArrayList<DeleteDocument>(documents.length));
        }
        for (DeleteDocument ele : documents) {
            this.documents.add(ele);
        }
        return this;
    }

    public BatchDeleteDocumentRequest withDocuments(Collection<DeleteDocument> documents) {
        this.setDocuments(documents);
        return this;
    }

    public void setDataSourceSyncId(String dataSourceSyncId) {
        this.dataSourceSyncId = dataSourceSyncId;
    }

    public String getDataSourceSyncId() {
        return this.dataSourceSyncId;
    }

    public BatchDeleteDocumentRequest withDataSourceSyncId(String dataSourceSyncId) {
        this.setDataSourceSyncId(dataSourceSyncId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getIndexId() != null) {
            sb.append("IndexId: ").append(this.getIndexId()).append(",");
        }
        if (this.getDocuments() != null) {
            sb.append("Documents: ").append(this.getDocuments()).append(",");
        }
        if (this.getDataSourceSyncId() != null) {
            sb.append("DataSourceSyncId: ").append(this.getDataSourceSyncId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDocumentRequest)) {
            return false;
        }
        BatchDeleteDocumentRequest other = (BatchDeleteDocumentRequest)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getIndexId() == null ^ this.getIndexId() == null) {
            return false;
        }
        if (other.getIndexId() != null && !other.getIndexId().equals(this.getIndexId())) {
            return false;
        }
        if (other.getDocuments() == null ^ this.getDocuments() == null) {
            return false;
        }
        if (other.getDocuments() != null && !other.getDocuments().equals(this.getDocuments())) {
            return false;
        }
        if (other.getDataSourceSyncId() == null ^ this.getDataSourceSyncId() == null) {
            return false;
        }
        return other.getDataSourceSyncId() == null || other.getDataSourceSyncId().equals(this.getDataSourceSyncId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getIndexId() == null ? 0 : this.getIndexId().hashCode());
        hashCode = 31 * hashCode + (this.getDocuments() == null ? 0 : this.getDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getDataSourceSyncId() == null ? 0 : this.getDataSourceSyncId().hashCode());
        return hashCode;
    }

    public BatchDeleteDocumentRequest clone() {
        return (BatchDeleteDocumentRequest)super.clone();
    }
}

