/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qbusiness.model.Document;
import java.util.List;

@SdkInternalApi
public class DocumentMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACCESSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessConfiguration").build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final MarshallingInfo<StructuredPojo> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("content").build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentType").build();
    private static final MarshallingInfo<StructuredPojo> DOCUMENTENRICHMENTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("documentEnrichmentConfiguration").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("title").build();
    private static final DocumentMarshaller instance = new DocumentMarshaller();

    public static DocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Document document, ProtocolMarshaller protocolMarshaller) {
        if (document == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)document.getAccessConfiguration(), ACCESSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(document.getAttributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)document.getContent(), CONTENT_BINDING);
            protocolMarshaller.marshall((Object)document.getContentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)document.getDocumentEnrichmentConfiguration(), DOCUMENTENRICHMENTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)document.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)document.getTitle(), TITLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

