/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.qbusiness.model.AttachmentInput;
import com.amazonaws.services.qbusiness.model.AttributeFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChatSyncRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationId;
    private List<AttachmentInput> attachments;
    private AttributeFilter attributeFilter;
    private String clientToken;
    private String conversationId;
    private String parentMessageId;
    private List<String> userGroups;
    private String userId;
    private String userMessage;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public ChatSyncRequest withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public List<AttachmentInput> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Collection<AttachmentInput> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        this.attachments = new ArrayList<AttachmentInput>(attachments);
    }

    public ChatSyncRequest withAttachments(AttachmentInput ... attachments) {
        if (this.attachments == null) {
            this.setAttachments(new ArrayList<AttachmentInput>(attachments.length));
        }
        for (AttachmentInput ele : attachments) {
            this.attachments.add(ele);
        }
        return this;
    }

    public ChatSyncRequest withAttachments(Collection<AttachmentInput> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public void setAttributeFilter(AttributeFilter attributeFilter) {
        this.attributeFilter = attributeFilter;
    }

    public AttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    public ChatSyncRequest withAttributeFilter(AttributeFilter attributeFilter) {
        this.setAttributeFilter(attributeFilter);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public ChatSyncRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public ChatSyncRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public void setParentMessageId(String parentMessageId) {
        this.parentMessageId = parentMessageId;
    }

    public String getParentMessageId() {
        return this.parentMessageId;
    }

    public ChatSyncRequest withParentMessageId(String parentMessageId) {
        this.setParentMessageId(parentMessageId);
        return this;
    }

    public List<String> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(Collection<String> userGroups) {
        if (userGroups == null) {
            this.userGroups = null;
            return;
        }
        this.userGroups = new ArrayList<String>(userGroups);
    }

    public ChatSyncRequest withUserGroups(String ... userGroups) {
        if (this.userGroups == null) {
            this.setUserGroups(new ArrayList<String>(userGroups.length));
        }
        for (String ele : userGroups) {
            this.userGroups.add(ele);
        }
        return this;
    }

    public ChatSyncRequest withUserGroups(Collection<String> userGroups) {
        this.setUserGroups(userGroups);
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public ChatSyncRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public ChatSyncRequest withUserMessage(String userMessage) {
        this.setUserMessage(userMessage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getAttachments() != null) {
            sb.append("Attachments: ").append(this.getAttachments()).append(",");
        }
        if (this.getAttributeFilter() != null) {
            sb.append("AttributeFilter: ").append(this.getAttributeFilter()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getConversationId() != null) {
            sb.append("ConversationId: ").append(this.getConversationId()).append(",");
        }
        if (this.getParentMessageId() != null) {
            sb.append("ParentMessageId: ").append(this.getParentMessageId()).append(",");
        }
        if (this.getUserGroups() != null) {
            sb.append("UserGroups: ").append(this.getUserGroups()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId()).append(",");
        }
        if (this.getUserMessage() != null) {
            sb.append("UserMessage: ").append(this.getUserMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatSyncRequest)) {
            return false;
        }
        ChatSyncRequest other = (ChatSyncRequest)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        if (other.getAttachments() != null && !other.getAttachments().equals(this.getAttachments())) {
            return false;
        }
        if (other.getAttributeFilter() == null ^ this.getAttributeFilter() == null) {
            return false;
        }
        if (other.getAttributeFilter() != null && !other.getAttributeFilter().equals(this.getAttributeFilter())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getConversationId() == null ^ this.getConversationId() == null) {
            return false;
        }
        if (other.getConversationId() != null && !other.getConversationId().equals(this.getConversationId())) {
            return false;
        }
        if (other.getParentMessageId() == null ^ this.getParentMessageId() == null) {
            return false;
        }
        if (other.getParentMessageId() != null && !other.getParentMessageId().equals(this.getParentMessageId())) {
            return false;
        }
        if (other.getUserGroups() == null ^ this.getUserGroups() == null) {
            return false;
        }
        if (other.getUserGroups() != null && !other.getUserGroups().equals(this.getUserGroups())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        if (other.getUserId() != null && !other.getUserId().equals(this.getUserId())) {
            return false;
        }
        if (other.getUserMessage() == null ^ this.getUserMessage() == null) {
            return false;
        }
        return other.getUserMessage() == null || other.getUserMessage().equals(this.getUserMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : this.getAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeFilter() == null ? 0 : this.getAttributeFilter().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getConversationId() == null ? 0 : this.getConversationId().hashCode());
        hashCode = 31 * hashCode + (this.getParentMessageId() == null ? 0 : this.getParentMessageId().hashCode());
        hashCode = 31 * hashCode + (this.getUserGroups() == null ? 0 : this.getUserGroups().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        hashCode = 31 * hashCode + (this.getUserMessage() == null ? 0 : this.getUserMessage().hashCode());
        return hashCode;
    }

    public ChatSyncRequest clone() {
        return (ChatSyncRequest)super.clone();
    }
}

