/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.proton;

import javax.annotation.Generated;

import com.amazonaws.services.proton.model.*;
import com.amazonaws.*;
import com.amazonaws.services.proton.waiters.AWSProtonWaiters;

/**
 * Abstract implementation of {@code AWSProton}. Convenient method forms pass through to the corresponding overload that
 * takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSProton implements AWSProton {

    protected AbstractAWSProton() {
    }

    @Override
    public AcceptEnvironmentAccountConnectionResult acceptEnvironmentAccountConnection(AcceptEnvironmentAccountConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelComponentDeploymentResult cancelComponentDeployment(CancelComponentDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelEnvironmentDeploymentResult cancelEnvironmentDeployment(CancelEnvironmentDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelServiceInstanceDeploymentResult cancelServiceInstanceDeployment(CancelServiceInstanceDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelServicePipelineDeploymentResult cancelServicePipelineDeployment(CancelServicePipelineDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateComponentResult createComponent(CreateComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEnvironmentResult createEnvironment(CreateEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEnvironmentAccountConnectionResult createEnvironmentAccountConnection(CreateEnvironmentAccountConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEnvironmentTemplateResult createEnvironmentTemplate(CreateEnvironmentTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEnvironmentTemplateVersionResult createEnvironmentTemplateVersion(CreateEnvironmentTemplateVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRepositoryResult createRepository(CreateRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceResult createService(CreateServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceInstanceResult createServiceInstance(CreateServiceInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceSyncConfigResult createServiceSyncConfig(CreateServiceSyncConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceTemplateResult createServiceTemplate(CreateServiceTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServiceTemplateVersionResult createServiceTemplateVersion(CreateServiceTemplateVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTemplateSyncConfigResult createTemplateSyncConfig(CreateTemplateSyncConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteComponentResult deleteComponent(DeleteComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeploymentResult deleteDeployment(DeleteDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEnvironmentResult deleteEnvironment(DeleteEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEnvironmentAccountConnectionResult deleteEnvironmentAccountConnection(DeleteEnvironmentAccountConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEnvironmentTemplateResult deleteEnvironmentTemplate(DeleteEnvironmentTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEnvironmentTemplateVersionResult deleteEnvironmentTemplateVersion(DeleteEnvironmentTemplateVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRepositoryResult deleteRepository(DeleteRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServiceResult deleteService(DeleteServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServiceSyncConfigResult deleteServiceSyncConfig(DeleteServiceSyncConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServiceTemplateResult deleteServiceTemplate(DeleteServiceTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServiceTemplateVersionResult deleteServiceTemplateVersion(DeleteServiceTemplateVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTemplateSyncConfigResult deleteTemplateSyncConfig(DeleteTemplateSyncConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountSettingsResult getAccountSettings(GetAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetComponentResult getComponent(GetComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeploymentResult getDeployment(GetDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEnvironmentResult getEnvironment(GetEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEnvironmentAccountConnectionResult getEnvironmentAccountConnection(GetEnvironmentAccountConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEnvironmentTemplateResult getEnvironmentTemplate(GetEnvironmentTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEnvironmentTemplateVersionResult getEnvironmentTemplateVersion(GetEnvironmentTemplateVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRepositoryResult getRepository(GetRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRepositorySyncStatusResult getRepositorySyncStatus(GetRepositorySyncStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourcesSummaryResult getResourcesSummary(GetResourcesSummaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceResult getService(GetServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceInstanceResult getServiceInstance(GetServiceInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceInstanceSyncStatusResult getServiceInstanceSyncStatus(GetServiceInstanceSyncStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceSyncBlockerSummaryResult getServiceSyncBlockerSummary(GetServiceSyncBlockerSummaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceSyncConfigResult getServiceSyncConfig(GetServiceSyncConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceTemplateResult getServiceTemplate(GetServiceTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceTemplateVersionResult getServiceTemplateVersion(GetServiceTemplateVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemplateSyncConfigResult getTemplateSyncConfig(GetTemplateSyncConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemplateSyncStatusResult getTemplateSyncStatus(GetTemplateSyncStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListComponentOutputsResult listComponentOutputs(ListComponentOutputsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListComponentProvisionedResourcesResult listComponentProvisionedResources(ListComponentProvisionedResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListComponentsResult listComponents(ListComponentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeploymentsResult listDeployments(ListDeploymentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentAccountConnectionsResult listEnvironmentAccountConnections(ListEnvironmentAccountConnectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentOutputsResult listEnvironmentOutputs(ListEnvironmentOutputsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentProvisionedResourcesResult listEnvironmentProvisionedResources(ListEnvironmentProvisionedResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentTemplateVersionsResult listEnvironmentTemplateVersions(ListEnvironmentTemplateVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentTemplatesResult listEnvironmentTemplates(ListEnvironmentTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnvironmentsResult listEnvironments(ListEnvironmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRepositoriesResult listRepositories(ListRepositoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRepositorySyncDefinitionsResult listRepositorySyncDefinitions(ListRepositorySyncDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServiceInstanceOutputsResult listServiceInstanceOutputs(ListServiceInstanceOutputsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServiceInstanceProvisionedResourcesResult listServiceInstanceProvisionedResources(ListServiceInstanceProvisionedResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServiceInstancesResult listServiceInstances(ListServiceInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServicePipelineOutputsResult listServicePipelineOutputs(ListServicePipelineOutputsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServicePipelineProvisionedResourcesResult listServicePipelineProvisionedResources(ListServicePipelineProvisionedResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServiceTemplateVersionsResult listServiceTemplateVersions(ListServiceTemplateVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServiceTemplatesResult listServiceTemplates(ListServiceTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServicesResult listServices(ListServicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public NotifyResourceDeploymentStatusChangeResult notifyResourceDeploymentStatusChange(NotifyResourceDeploymentStatusChangeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectEnvironmentAccountConnectionResult rejectEnvironmentAccountConnection(RejectEnvironmentAccountConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccountSettingsResult updateAccountSettings(UpdateAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateComponentResult updateComponent(UpdateComponentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEnvironmentResult updateEnvironment(UpdateEnvironmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEnvironmentAccountConnectionResult updateEnvironmentAccountConnection(UpdateEnvironmentAccountConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEnvironmentTemplateResult updateEnvironmentTemplate(UpdateEnvironmentTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEnvironmentTemplateVersionResult updateEnvironmentTemplateVersion(UpdateEnvironmentTemplateVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceResult updateService(UpdateServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceInstanceResult updateServiceInstance(UpdateServiceInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServicePipelineResult updateServicePipeline(UpdateServicePipelineRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceSyncBlockerResult updateServiceSyncBlocker(UpdateServiceSyncBlockerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceSyncConfigResult updateServiceSyncConfig(UpdateServiceSyncConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceTemplateResult updateServiceTemplate(UpdateServiceTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateServiceTemplateVersionResult updateServiceTemplateVersion(UpdateServiceTemplateVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplateSyncConfigResult updateTemplateSyncConfig(UpdateTemplateSyncConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AWSProtonWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
