/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.prometheus.model.WorkspaceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListWorkspacesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<WorkspaceSummary> workspaces;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListWorkspacesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<WorkspaceSummary> getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(Collection<WorkspaceSummary> workspaces) {
        if (workspaces == null) {
            this.workspaces = null;
            return;
        }
        this.workspaces = new ArrayList<WorkspaceSummary>(workspaces);
    }

    public ListWorkspacesResult withWorkspaces(WorkspaceSummary ... workspaces) {
        if (this.workspaces == null) {
            this.setWorkspaces(new ArrayList<WorkspaceSummary>(workspaces.length));
        }
        for (WorkspaceSummary ele : workspaces) {
            this.workspaces.add(ele);
        }
        return this;
    }

    public ListWorkspacesResult withWorkspaces(Collection<WorkspaceSummary> workspaces) {
        this.setWorkspaces(workspaces);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getWorkspaces() != null) {
            sb.append("Workspaces: ").append(this.getWorkspaces());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspacesResult)) {
            return false;
        }
        ListWorkspacesResult other = (ListWorkspacesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getWorkspaces() == null ^ this.getWorkspaces() == null) {
            return false;
        }
        return other.getWorkspaces() == null || other.getWorkspaces().equals(this.getWorkspaces());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaces() == null ? 0 : this.getWorkspaces().hashCode());
        return hashCode;
    }

    public ListWorkspacesResult clone() {
        try {
            return (ListWorkspacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

