/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.presign;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.SdkClock;
import com.amazonaws.auth.presign.PresignerFacade;
import com.amazonaws.auth.presign.PresignerParams;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.polly.presign.SynthesizeSpeechPresignRequest;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import org.joda.time.DateTime;

public final class AmazonPollyPresigners {
    private static final int SYNTHESIZE_SPEECH_DEFAULT_EXPIRATION_MINUTES = 15;
    private final URI endpoint;
    private final PresignerFacade presignerFacade;
    private final SdkClock clock;

    @SdkInternalApi
    public AmazonPollyPresigners(PresignerParams presignerParams) {
        this.endpoint = presignerParams.endpoint();
        this.presignerFacade = new PresignerFacade(presignerParams);
        this.clock = presignerParams.clock();
    }

    public URL getPresignedSynthesizeSpeechUrl(SynthesizeSpeechPresignRequest synthesizeSpeechPresignRequest) {
        Request<?> request = this.newRequest(synthesizeSpeechPresignRequest.getSigningCredentials());
        request.setEndpoint(this.endpoint);
        request.setResourcePath("/v1/speech");
        request.setHttpMethod(HttpMethodName.GET);
        this.marshallIntoRequest(synthesizeSpeechPresignRequest, request);
        Date expirationDate = synthesizeSpeechPresignRequest.getExpirationDate() == null ? this.getDefaultExpirationDate() : synthesizeSpeechPresignRequest.getExpirationDate();
        return this.presignerFacade.presign(request, expirationDate);
    }

    private void marshallIntoRequest(SynthesizeSpeechPresignRequest synthesizeSpeechRequest, Request<?> request) {
        if (synthesizeSpeechRequest.getText() != null) {
            request.addParameter("Text", synthesizeSpeechRequest.getText());
        }
        if (synthesizeSpeechRequest.getTextType() != null) {
            request.addParameter("TextType", synthesizeSpeechRequest.getTextType());
        }
        if (synthesizeSpeechRequest.getVoiceId() != null) {
            request.addParameter("VoiceId", synthesizeSpeechRequest.getVoiceId());
        }
        if (synthesizeSpeechRequest.getSampleRate() != null) {
            request.addParameter("SampleRate", synthesizeSpeechRequest.getSampleRate());
        }
        if (synthesizeSpeechRequest.getOutputFormat() != null) {
            request.addParameter("OutputFormat", synthesizeSpeechRequest.getOutputFormat());
        }
        if (synthesizeSpeechRequest.getLexiconNames() != null) {
            for (String lexiconName : synthesizeSpeechRequest.getLexiconNames()) {
                request.addParameter("LexiconNames", lexiconName);
            }
        }
        if (synthesizeSpeechRequest.getSpeechMarkTypes() != null) {
            for (String speechMarkType : synthesizeSpeechRequest.getSpeechMarkTypes()) {
                request.addParameter("SpeechMarkTypes", speechMarkType);
            }
        }
        if (synthesizeSpeechRequest.getLanguageCode() != null) {
            request.addParameter("LanguageCode", synthesizeSpeechRequest.getLanguageCode());
        }
        if (synthesizeSpeechRequest.getEngine() != null) {
            request.addParameter("Engine", synthesizeSpeechRequest.getEngine());
        }
    }

    private Request<?> newRequest(AWSCredentialsProvider credentials) {
        return new DefaultRequest((AmazonWebServiceRequest)new PresignerFacade.PresigningRequest().withRequestCredentialsProvider(credentials), "AmazonPolly");
    }

    private Date getDefaultExpirationDate() {
        return new DateTime(this.clock.currentTimeMillis()).plusMinutes(15).toDate();
    }
}

