/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.CreateCampaignRequest;
import com.amazonaws.services.pinpoint.model.WriteCampaignRequest;
import com.amazonaws.services.pinpoint.model.WriteTreatmentResource;
import com.amazonaws.services.pinpoint.model.transform.CampaignLimitsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.MessageConfigurationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.ScheduleJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.WriteTreatmentResourceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateCampaignRequestMarshaller
implements Marshaller<Request<CreateCampaignRequest>, CreateCampaignRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateCampaignRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateCampaignRequest> marshall(CreateCampaignRequest createCampaignRequest) {
        if (createCampaignRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCampaignRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/apps/{application-id}/campaigns";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", createCampaignRequest.getApplicationId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            WriteCampaignRequest writeCampaignRequest = createCampaignRequest.getWriteCampaignRequest();
            if (writeCampaignRequest != null) {
                jsonGenerator.writeStartObject();
                List<WriteTreatmentResource> additionalTreatmentsList = writeCampaignRequest.getAdditionalTreatments();
                if (additionalTreatmentsList != null) {
                    jsonGenerator.writeFieldName("AdditionalTreatments");
                    jsonGenerator.writeStartArray();
                    for (WriteTreatmentResource additionalTreatmentsListValue : additionalTreatmentsList) {
                        if (additionalTreatmentsListValue == null) continue;
                        WriteTreatmentResourceJsonMarshaller.getInstance().marshall(additionalTreatmentsListValue, jsonGenerator);
                    }
                    jsonGenerator.writeEndArray();
                }
                if (writeCampaignRequest.getDescription() != null) {
                    jsonGenerator.writeFieldName("Description").writeValue(writeCampaignRequest.getDescription());
                }
                if (writeCampaignRequest.getHoldoutPercent() != null) {
                    jsonGenerator.writeFieldName("HoldoutPercent").writeValue(writeCampaignRequest.getHoldoutPercent().intValue());
                }
                if (writeCampaignRequest.getIsPaused() != null) {
                    jsonGenerator.writeFieldName("IsPaused").writeValue(writeCampaignRequest.getIsPaused().booleanValue());
                }
                if (writeCampaignRequest.getLimits() != null) {
                    jsonGenerator.writeFieldName("Limits");
                    CampaignLimitsJsonMarshaller.getInstance().marshall(writeCampaignRequest.getLimits(), jsonGenerator);
                }
                if (writeCampaignRequest.getMessageConfiguration() != null) {
                    jsonGenerator.writeFieldName("MessageConfiguration");
                    MessageConfigurationJsonMarshaller.getInstance().marshall(writeCampaignRequest.getMessageConfiguration(), jsonGenerator);
                }
                if (writeCampaignRequest.getName() != null) {
                    jsonGenerator.writeFieldName("Name").writeValue(writeCampaignRequest.getName());
                }
                if (writeCampaignRequest.getSchedule() != null) {
                    jsonGenerator.writeFieldName("Schedule");
                    ScheduleJsonMarshaller.getInstance().marshall(writeCampaignRequest.getSchedule(), jsonGenerator);
                }
                if (writeCampaignRequest.getSegmentId() != null) {
                    jsonGenerator.writeFieldName("SegmentId").writeValue(writeCampaignRequest.getSegmentId());
                }
                if (writeCampaignRequest.getSegmentVersion() != null) {
                    jsonGenerator.writeFieldName("SegmentVersion").writeValue(writeCampaignRequest.getSegmentVersion().intValue());
                }
                if (writeCampaignRequest.getTreatmentDescription() != null) {
                    jsonGenerator.writeFieldName("TreatmentDescription").writeValue(writeCampaignRequest.getTreatmentDescription());
                }
                if (writeCampaignRequest.getTreatmentName() != null) {
                    jsonGenerator.writeFieldName("TreatmentName").writeValue(writeCampaignRequest.getTreatmentName());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

