/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeruntime.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.personalizeruntime.model.PredictedItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetRecommendationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PredictedItem> itemList;
    private String recommendationId;

    public List<PredictedItem> getItemList() {
        return this.itemList;
    }

    public void setItemList(Collection<PredictedItem> itemList) {
        if (itemList == null) {
            this.itemList = null;
            return;
        }
        this.itemList = new ArrayList<PredictedItem>(itemList);
    }

    public GetRecommendationsResult withItemList(PredictedItem ... itemList) {
        if (this.itemList == null) {
            this.setItemList(new ArrayList<PredictedItem>(itemList.length));
        }
        for (PredictedItem ele : itemList) {
            this.itemList.add(ele);
        }
        return this;
    }

    public GetRecommendationsResult withItemList(Collection<PredictedItem> itemList) {
        this.setItemList(itemList);
        return this;
    }

    public void setRecommendationId(String recommendationId) {
        this.recommendationId = recommendationId;
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public GetRecommendationsResult withRecommendationId(String recommendationId) {
        this.setRecommendationId(recommendationId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItemList() != null) {
            sb.append("ItemList: ").append(this.getItemList()).append(",");
        }
        if (this.getRecommendationId() != null) {
            sb.append("RecommendationId: ").append(this.getRecommendationId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResult)) {
            return false;
        }
        GetRecommendationsResult other = (GetRecommendationsResult)obj;
        if (other.getItemList() == null ^ this.getItemList() == null) {
            return false;
        }
        if (other.getItemList() != null && !other.getItemList().equals(this.getItemList())) {
            return false;
        }
        if (other.getRecommendationId() == null ^ this.getRecommendationId() == null) {
            return false;
        }
        return other.getRecommendationId() == null || other.getRecommendationId().equals(this.getRecommendationId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItemList() == null ? 0 : this.getItemList().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationId() == null ? 0 : this.getRecommendationId().hashCode());
        return hashCode;
    }

    public GetRecommendationsResult clone() {
        try {
            return (GetRecommendationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

