/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.personalizeevents.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutEvents" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutEventsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The tracking ID for the event. The ID is generated by a call to the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a> API.
     * </p>
     */
    private String trackingId;
    /**
     * <p>
     * The user associated with the event.
     * </p>
     */
    private String userId;
    /**
     * <p>
     * The session ID associated with the user's visit. Your application generates the sessionId when a user first
     * visits your website or uses your application. Amazon Personalize uses the sessionId to associate events with the
     * user before they log in. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
     * </p>
     */
    private String sessionId;
    /**
     * <p>
     * A list of event data from the session.
     * </p>
     */
    private java.util.List<Event> eventList;

    /**
     * <p>
     * The tracking ID for the event. The ID is generated by a call to the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a> API.
     * </p>
     * 
     * @param trackingId
     *        The tracking ID for the event. The ID is generated by a call to the <a
     *        href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html"
     *        >CreateEventTracker</a> API.
     */

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    /**
     * <p>
     * The tracking ID for the event. The ID is generated by a call to the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a> API.
     * </p>
     * 
     * @return The tracking ID for the event. The ID is generated by a call to the <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html"
     *         >CreateEventTracker</a> API.
     */

    public String getTrackingId() {
        return this.trackingId;
    }

    /**
     * <p>
     * The tracking ID for the event. The ID is generated by a call to the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a> API.
     * </p>
     * 
     * @param trackingId
     *        The tracking ID for the event. The ID is generated by a call to the <a
     *        href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html"
     *        >CreateEventTracker</a> API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutEventsRequest withTrackingId(String trackingId) {
        setTrackingId(trackingId);
        return this;
    }

    /**
     * <p>
     * The user associated with the event.
     * </p>
     * 
     * @param userId
     *        The user associated with the event.
     */

    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * <p>
     * The user associated with the event.
     * </p>
     * 
     * @return The user associated with the event.
     */

    public String getUserId() {
        return this.userId;
    }

    /**
     * <p>
     * The user associated with the event.
     * </p>
     * 
     * @param userId
     *        The user associated with the event.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutEventsRequest withUserId(String userId) {
        setUserId(userId);
        return this;
    }

    /**
     * <p>
     * The session ID associated with the user's visit. Your application generates the sessionId when a user first
     * visits your website or uses your application. Amazon Personalize uses the sessionId to associate events with the
     * user before they log in. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
     * </p>
     * 
     * @param sessionId
     *        The session ID associated with the user's visit. Your application generates the sessionId when a user
     *        first visits your website or uses your application. Amazon Personalize uses the sessionId to associate
     *        events with the user before they log in. For more information, see <a
     *        href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
     */

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    /**
     * <p>
     * The session ID associated with the user's visit. Your application generates the sessionId when a user first
     * visits your website or uses your application. Amazon Personalize uses the sessionId to associate events with the
     * user before they log in. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
     * </p>
     * 
     * @return The session ID associated with the user's visit. Your application generates the sessionId when a user
     *         first visits your website or uses your application. Amazon Personalize uses the sessionId to associate
     *         events with the user before they log in. For more information, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
     */

    public String getSessionId() {
        return this.sessionId;
    }

    /**
     * <p>
     * The session ID associated with the user's visit. Your application generates the sessionId when a user first
     * visits your website or uses your application. Amazon Personalize uses the sessionId to associate events with the
     * user before they log in. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
     * </p>
     * 
     * @param sessionId
     *        The session ID associated with the user's visit. Your application generates the sessionId when a user
     *        first visits your website or uses your application. Amazon Personalize uses the sessionId to associate
     *        events with the user before they log in. For more information, see <a
     *        href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutEventsRequest withSessionId(String sessionId) {
        setSessionId(sessionId);
        return this;
    }

    /**
     * <p>
     * A list of event data from the session.
     * </p>
     * 
     * @return A list of event data from the session.
     */

    public java.util.List<Event> getEventList() {
        return eventList;
    }

    /**
     * <p>
     * A list of event data from the session.
     * </p>
     * 
     * @param eventList
     *        A list of event data from the session.
     */

    public void setEventList(java.util.Collection<Event> eventList) {
        if (eventList == null) {
            this.eventList = null;
            return;
        }

        this.eventList = new java.util.ArrayList<Event>(eventList);
    }

    /**
     * <p>
     * A list of event data from the session.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEventList(java.util.Collection)} or {@link #withEventList(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param eventList
     *        A list of event data from the session.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutEventsRequest withEventList(Event... eventList) {
        if (this.eventList == null) {
            setEventList(new java.util.ArrayList<Event>(eventList.length));
        }
        for (Event ele : eventList) {
            this.eventList.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of event data from the session.
     * </p>
     * 
     * @param eventList
     *        A list of event data from the session.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutEventsRequest withEventList(java.util.Collection<Event> eventList) {
        setEventList(eventList);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTrackingId() != null)
            sb.append("TrackingId: ").append(getTrackingId()).append(",");
        if (getUserId() != null)
            sb.append("UserId: ").append("***Sensitive Data Redacted***").append(",");
        if (getSessionId() != null)
            sb.append("SessionId: ").append(getSessionId()).append(",");
        if (getEventList() != null)
            sb.append("EventList: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutEventsRequest == false)
            return false;
        PutEventsRequest other = (PutEventsRequest) obj;
        if (other.getTrackingId() == null ^ this.getTrackingId() == null)
            return false;
        if (other.getTrackingId() != null && other.getTrackingId().equals(this.getTrackingId()) == false)
            return false;
        if (other.getUserId() == null ^ this.getUserId() == null)
            return false;
        if (other.getUserId() != null && other.getUserId().equals(this.getUserId()) == false)
            return false;
        if (other.getSessionId() == null ^ this.getSessionId() == null)
            return false;
        if (other.getSessionId() != null && other.getSessionId().equals(this.getSessionId()) == false)
            return false;
        if (other.getEventList() == null ^ this.getEventList() == null)
            return false;
        if (other.getEventList() != null && other.getEventList().equals(this.getEventList()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTrackingId() == null) ? 0 : getTrackingId().hashCode());
        hashCode = prime * hashCode + ((getUserId() == null) ? 0 : getUserId().hashCode());
        hashCode = prime * hashCode + ((getSessionId() == null) ? 0 : getSessionId().hashCode());
        hashCode = prime * hashCode + ((getEventList() == null) ? 0 : getEventList().hashCode());
        return hashCode;
    }

    @Override
    public PutEventsRequest clone() {
        return (PutEventsRequest) super.clone();
    }

}
