/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeevents.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.personalizeevents.model.Event;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class EventMarshaller {
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventId").build();
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventType").build();
    private static final MarshallingInfo<Float> EVENTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventValue").build();
    private static final MarshallingInfo<String> ITEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("itemId").build();
    private static final MarshallingInfo<String> PROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.JSON_VALUE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("properties").build();
    private static final MarshallingInfo<Date> SENTAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sentAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RECOMMENDATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recommendationId").build();
    private static final MarshallingInfo<List> IMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("impression").build();
    private static final EventMarshaller instance = new EventMarshaller();

    public static EventMarshaller getInstance() {
        return instance;
    }

    public void marshall(Event event, ProtocolMarshaller protocolMarshaller) {
        if (event == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)event.getEventId(), EVENTID_BINDING);
            protocolMarshaller.marshall((Object)event.getEventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)event.getEventValue(), EVENTVALUE_BINDING);
            protocolMarshaller.marshall((Object)event.getItemId(), ITEMID_BINDING);
            protocolMarshaller.marshall((Object)event.getProperties(), PROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)event.getSentAt(), SENTAT_BINDING);
            protocolMarshaller.marshall((Object)event.getRecommendationId(), RECOMMENDATIONID_BINDING);
            protocolMarshaller.marshall(event.getImpression(), IMPRESSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

