/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.personalize.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.personalize.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SolutionConfig JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SolutionConfigJsonUnmarshaller implements Unmarshaller<SolutionConfig, JsonUnmarshallerContext> {

    public SolutionConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        SolutionConfig solutionConfig = new SolutionConfig();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("eventValueThreshold", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setEventValueThreshold(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("hpoConfig", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setHpoConfig(HPOConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("algorithmHyperParameters", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setAlgorithmHyperParameters(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("featureTransformationParameters", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setFeatureTransformationParameters(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("autoMLConfig", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setAutoMLConfig(AutoMLConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("optimizationObjective", targetDepth)) {
                    context.nextToken();
                    solutionConfig.setOptimizationObjective(OptimizationObjectiveJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return solutionConfig;
    }

    private static SolutionConfigJsonUnmarshaller instance;

    public static SolutionConfigJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new SolutionConfigJsonUnmarshaller();
        return instance;
    }
}
