/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.personalize;

import javax.annotation.Generated;

import com.amazonaws.services.personalize.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonPersonalize}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonPersonalize implements AmazonPersonalize {

    protected AbstractAmazonPersonalize() {
    }

    @Override
    public CreateBatchInferenceJobResult createBatchInferenceJob(CreateBatchInferenceJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCampaignResult createCampaign(CreateCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetExportJobResult createDatasetExportJob(CreateDatasetExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetGroupResult createDatasetGroup(CreateDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetImportJobResult createDatasetImportJob(CreateDatasetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEventTrackerResult createEventTracker(CreateEventTrackerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFilterResult createFilter(CreateFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSchemaResult createSchema(CreateSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSolutionResult createSolution(CreateSolutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSolutionVersionResult createSolutionVersion(CreateSolutionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCampaignResult deleteCampaign(DeleteCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetGroupResult deleteDatasetGroup(DeleteDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEventTrackerResult deleteEventTracker(DeleteEventTrackerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFilterResult deleteFilter(DeleteFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSchemaResult deleteSchema(DeleteSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSolutionResult deleteSolution(DeleteSolutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAlgorithmResult describeAlgorithm(DescribeAlgorithmRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBatchInferenceJobResult describeBatchInferenceJob(DescribeBatchInferenceJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCampaignResult describeCampaign(DescribeCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetExportJobResult describeDatasetExportJob(DescribeDatasetExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetGroupResult describeDatasetGroup(DescribeDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetImportJobResult describeDatasetImportJob(DescribeDatasetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEventTrackerResult describeEventTracker(DescribeEventTrackerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFeatureTransformationResult describeFeatureTransformation(DescribeFeatureTransformationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFilterResult describeFilter(DescribeFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRecipeResult describeRecipe(DescribeRecipeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSchemaResult describeSchema(DescribeSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSolutionResult describeSolution(DescribeSolutionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSolutionVersionResult describeSolutionVersion(DescribeSolutionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSolutionMetricsResult getSolutionMetrics(GetSolutionMetricsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBatchInferenceJobsResult listBatchInferenceJobs(ListBatchInferenceJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCampaignsResult listCampaigns(ListCampaignsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetExportJobsResult listDatasetExportJobs(ListDatasetExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetGroupsResult listDatasetGroups(ListDatasetGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetImportJobsResult listDatasetImportJobs(ListDatasetImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEventTrackersResult listEventTrackers(ListEventTrackersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFiltersResult listFilters(ListFiltersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRecipesResult listRecipes(ListRecipesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSchemasResult listSchemas(ListSchemasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSolutionVersionsResult listSolutionVersions(ListSolutionVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSolutionsResult listSolutions(ListSolutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCampaignResult updateCampaign(UpdateCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
