/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptographydata.model.MacAlgorithm;
import com.amazonaws.services.paymentcryptographydata.model.MacAlgorithmDukpt;
import com.amazonaws.services.paymentcryptographydata.model.MacAlgorithmEmv;
import com.amazonaws.services.paymentcryptographydata.model.transform.MacAttributesMarshaller;
import java.io.Serializable;

public class MacAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithm;
    private MacAlgorithmEmv emvMac;
    private MacAlgorithmDukpt dukptIso9797Algorithm1;
    private MacAlgorithmDukpt dukptIso9797Algorithm3;
    private MacAlgorithmDukpt dukptCmac;

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public MacAttributes withAlgorithm(String algorithm) {
        this.setAlgorithm(algorithm);
        return this;
    }

    public MacAttributes withAlgorithm(MacAlgorithm algorithm) {
        this.algorithm = algorithm.toString();
        return this;
    }

    public void setEmvMac(MacAlgorithmEmv emvMac) {
        this.emvMac = emvMac;
    }

    public MacAlgorithmEmv getEmvMac() {
        return this.emvMac;
    }

    public MacAttributes withEmvMac(MacAlgorithmEmv emvMac) {
        this.setEmvMac(emvMac);
        return this;
    }

    public void setDukptIso9797Algorithm1(MacAlgorithmDukpt dukptIso9797Algorithm1) {
        this.dukptIso9797Algorithm1 = dukptIso9797Algorithm1;
    }

    public MacAlgorithmDukpt getDukptIso9797Algorithm1() {
        return this.dukptIso9797Algorithm1;
    }

    public MacAttributes withDukptIso9797Algorithm1(MacAlgorithmDukpt dukptIso9797Algorithm1) {
        this.setDukptIso9797Algorithm1(dukptIso9797Algorithm1);
        return this;
    }

    public void setDukptIso9797Algorithm3(MacAlgorithmDukpt dukptIso9797Algorithm3) {
        this.dukptIso9797Algorithm3 = dukptIso9797Algorithm3;
    }

    public MacAlgorithmDukpt getDukptIso9797Algorithm3() {
        return this.dukptIso9797Algorithm3;
    }

    public MacAttributes withDukptIso9797Algorithm3(MacAlgorithmDukpt dukptIso9797Algorithm3) {
        this.setDukptIso9797Algorithm3(dukptIso9797Algorithm3);
        return this;
    }

    public void setDukptCmac(MacAlgorithmDukpt dukptCmac) {
        this.dukptCmac = dukptCmac;
    }

    public MacAlgorithmDukpt getDukptCmac() {
        return this.dukptCmac;
    }

    public MacAttributes withDukptCmac(MacAlgorithmDukpt dukptCmac) {
        this.setDukptCmac(dukptCmac);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithm() != null) {
            sb.append("Algorithm: ").append(this.getAlgorithm()).append(",");
        }
        if (this.getEmvMac() != null) {
            sb.append("EmvMac: ").append(this.getEmvMac()).append(",");
        }
        if (this.getDukptIso9797Algorithm1() != null) {
            sb.append("DukptIso9797Algorithm1: ").append(this.getDukptIso9797Algorithm1()).append(",");
        }
        if (this.getDukptIso9797Algorithm3() != null) {
            sb.append("DukptIso9797Algorithm3: ").append(this.getDukptIso9797Algorithm3()).append(",");
        }
        if (this.getDukptCmac() != null) {
            sb.append("DukptCmac: ").append(this.getDukptCmac());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacAttributes)) {
            return false;
        }
        MacAttributes other = (MacAttributes)obj;
        if (other.getAlgorithm() == null ^ this.getAlgorithm() == null) {
            return false;
        }
        if (other.getAlgorithm() != null && !other.getAlgorithm().equals(this.getAlgorithm())) {
            return false;
        }
        if (other.getEmvMac() == null ^ this.getEmvMac() == null) {
            return false;
        }
        if (other.getEmvMac() != null && !other.getEmvMac().equals(this.getEmvMac())) {
            return false;
        }
        if (other.getDukptIso9797Algorithm1() == null ^ this.getDukptIso9797Algorithm1() == null) {
            return false;
        }
        if (other.getDukptIso9797Algorithm1() != null && !other.getDukptIso9797Algorithm1().equals(this.getDukptIso9797Algorithm1())) {
            return false;
        }
        if (other.getDukptIso9797Algorithm3() == null ^ this.getDukptIso9797Algorithm3() == null) {
            return false;
        }
        if (other.getDukptIso9797Algorithm3() != null && !other.getDukptIso9797Algorithm3().equals(this.getDukptIso9797Algorithm3())) {
            return false;
        }
        if (other.getDukptCmac() == null ^ this.getDukptCmac() == null) {
            return false;
        }
        return other.getDukptCmac() == null || other.getDukptCmac().equals(this.getDukptCmac());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithm() == null ? 0 : this.getAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getEmvMac() == null ? 0 : this.getEmvMac().hashCode());
        hashCode = 31 * hashCode + (this.getDukptIso9797Algorithm1() == null ? 0 : this.getDukptIso9797Algorithm1().hashCode());
        hashCode = 31 * hashCode + (this.getDukptIso9797Algorithm3() == null ? 0 : this.getDukptIso9797Algorithm3().hashCode());
        hashCode = 31 * hashCode + (this.getDukptCmac() == null ? 0 : this.getDukptCmac().hashCode());
        return hashCode;
    }

    public MacAttributes clone() {
        try {
            return (MacAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MacAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

